/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.dilemma.strategy.internals;

import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.Strategy;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaState;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaRoundData;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaStrategy;
import de.fhdw.gaming.ipspiel23.memory.GameMemoryIdentifier;
import de.fhdw.gaming.ipspiel23.memory.IGameMemory;
import de.fhdw.gaming.ipspiel23.memory.IGameMemoryCapacity;
import de.fhdw.gaming.ipspiel23.memory.IGameMemoryIdentifier;
import de.fhdw.gaming.ipspiel23.memory.IGameMemoryProvider;

public abstract class DilemmaMemoryStrategy
extends DilemmaStrategy {
    protected DilemmaMemoryStrategy(IDilemmaMoveFactory moveFactory) {
        super(moveFactory);
    }

    protected abstract IGameMemoryCapacity requestedMemoryCapacity();

    protected final IGameMemory<DilemmaRoundData> getMemoryForPlayer(IDilemmaPlayer player, IDilemmaState state) {
        IGameMemoryProvider memoryProvider = state.getMemoryProvider();
        IDilemmaPlayer opponent = state.getOpponentOf(player);
        IGameMemoryIdentifier identifier = GameMemoryIdentifier.of((Player)player, (Strategy)player.getStrategy(), (Strategy)opponent.getStrategy());
        return memoryProvider.requestMemoryForStrategy(identifier, this.requestedMemoryCapacity());
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.toString().hashCode();
        return hash;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public boolean equals(Object other) {
        return other != null && other.getClass().equals(this.getClass()) && other.hashCode() == this.hashCode();
    }
}

