/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.random;

import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaState;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMove;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaStrategy;
import java.util.Optional;
import java.util.Random;

public class DilemmaRandomStrategy
extends DilemmaStrategy {
    private static final Random RANDOM = new Random();

    DilemmaRandomStrategy(IDilemmaMoveFactory moveFactory) {
        super(moveFactory);
    }

    public Optional<IDilemmaMove> computeNextMove(int gameId, IDilemmaPlayer player, IDilemmaState state) {
        return Optional.of(RANDOM.nextBoolean() ? this.getMoveFactory().createCooperateMove() : this.getMoveFactory().createDefectMove());
    }

    public String toString() {
        return DilemmaRandomStrategy.class.getSimpleName();
    }

    public boolean equals(Object object) {
        if (object instanceof DilemmaRandomStrategy) {
            DilemmaRandomStrategy randomStrategy = (DilemmaRandomStrategy)object;
            return this.toString().equals(randomStrategy.toString());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() * this.toString().hashCode();
    }
}

