package de.fhdw.gaming.ipspiel23.gst.domain.impl;

import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;
import de.fhdw.gaming.ipspiel23.gst.domain.ICalculatorKopplung;
import de.fhdw.gaming.ipspiel23.gst.domain.IKopplung;
import de.fhdw.gaming.ipspiel23.gst.strategies.domain.IGstKopplungsMiniMaxStrategy;

/**
 * The implementation of the ICalculatorKopplung interface for calculating the next move for the current player in a
 * game.
 *
 * @param <P> The type of player in the game.
 * @param <S> The type of state in the game.
 * @author borkowitz
 */
public class GstKopplungsMoveCalculator<P extends Player<P>, S extends State<P, S>>
        implements ICalculatorKopplung<P, S> {

    /**
     * Calculates the next best move for the current Player in the game based on the given parameters.
     *
     * @param kopplung               The game object representing the specific game being played.
     * @param state                  The current state of the game.
     * @param maximumComputationTime The maximum computation time allowed for calculating the move (in seconds).
     * @param strategy               The mini-max strategy used for calculating the move.
     * @return The calculated move for the player in the given state.
     */
    @Override
    public Move<P, S> calculateMove(final IKopplung<P, S> kopplung, final S state,
            final Integer maximumComputationTime,
            final IGstKopplungsMiniMaxStrategy<P, S> strategy) {
        return strategy.calculateBestMove(kopplung, state, maximumComputationTime).get();
    }
}
