/*
 * Copyright © 2021-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel23-Ssp.
 *
 * Ipspiel23-Ssp is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel23-Ssp is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel23-Ssp. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel23.ssp.domain.impl.outcomes;


/** Represents possible answers in a Ssp Game.
 * 
 * @author DW
 *
 */
public enum SspAnswer {

    /**
     * Represents the answer "stone".
     */
    PAPER, 
    
    /**
     * Represents the answer "paper".
     */
    STONE, 
    
    /**
     * Represents the answer "scissors".
     */
    SCISSORS;

    @Override
    public String toString() {
        return this.name().toLowerCase();
    }
}
