/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.ssp.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.ipspiel23.ssp.domain.SspPlayer;
import de.fhdw.gaming.ipspiel23.ssp.domain.SspState;
import de.fhdw.gaming.ipspiel23.ssp.domain.impl.outcomes.SspAnswer;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class SspStateImpl
implements SspState {
    private final SspPlayer firstPlayer;
    private final SspPlayer secondPlayer;

    SspStateImpl(SspPlayer firstPlayer, SspPlayer secondPlayer) throws GameException {
        this.firstPlayer = Objects.requireNonNull(firstPlayer, "firstPlayer");
        this.secondPlayer = Objects.requireNonNull(secondPlayer, "secondPlayer");
        if (this.firstPlayer.getName().equals(this.secondPlayer.getName())) {
            throw new IllegalArgumentException(String.format("Both players have the same name '%s'.", this.firstPlayer.getName()));
        }
    }

    SspStateImpl(SspStateImpl source) {
        this.firstPlayer = source.firstPlayer.deepCopy();
        this.secondPlayer = source.secondPlayer.deepCopy();
    }

    @Override
    public SspPlayer getFirstPlayer() {
        return this.firstPlayer;
    }

    @Override
    public SspPlayer getSecondPlayer() {
        return this.secondPlayer;
    }

    public String toString() {
        return String.format("SspState[firstPlayer=%s, secondPlayer=%s]", this.firstPlayer, this.secondPlayer);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SspStateImpl) {
            SspStateImpl other = (SspStateImpl)obj;
            return this.firstPlayer.equals(other.firstPlayer) && this.secondPlayer.equals(other.secondPlayer);
        }
        return false;
    }

    public SspState deepCopy() {
        return new SspStateImpl(this);
    }

    public int hashCode() {
        return Objects.hash(this.firstPlayer, this.secondPlayer);
    }

    public Map<String, SspPlayer> getPlayers() {
        LinkedHashMap<String, SspPlayer> result = new LinkedHashMap<String, SspPlayer>();
        result.put(this.firstPlayer.getName(), this.firstPlayer);
        result.put(this.secondPlayer.getName(), this.secondPlayer);
        return result;
    }

    public Set<SspPlayer> computeNextPlayers() {
        LinkedHashSet<SspPlayer> playersWithoutMove = new LinkedHashSet<SspPlayer>();
        if (this.firstPlayer.getAnswer().isEmpty()) {
            playersWithoutMove.add(this.firstPlayer);
        }
        if (this.secondPlayer.getAnswer().isEmpty()) {
            playersWithoutMove.add(this.secondPlayer);
        }
        return playersWithoutMove;
    }

    public void nextTurn() {
        Set<SspPlayer> playersWithoutMove = this.computeNextPlayers();
        if (playersWithoutMove.isEmpty()) {
            SspAnswer answerOfFirstPlayer = this.firstPlayer.getAnswer().orElseThrow();
            SspAnswer answerOfSecondPlayer = this.secondPlayer.getAnswer().orElseThrow();
            Map<SspAnswer, Map<SspAnswer, Double>> outcomesPlayer1 = this.firstPlayer.getPossibleOutcomes();
            Double outcomeOfFirstPlayer = outcomesPlayer1.get((Object)answerOfFirstPlayer).get((Object)answerOfSecondPlayer);
            this.firstPlayer.setState(SspStateImpl.outcomeToState(outcomeOfFirstPlayer));
            this.firstPlayer.setOutcome(outcomeOfFirstPlayer);
            Map<SspAnswer, Map<SspAnswer, Double>> outcomesPlayer2 = this.secondPlayer.getPossibleOutcomes();
            Double outcomeOfSecondPlayer = outcomesPlayer2.get((Object)answerOfSecondPlayer).get((Object)answerOfFirstPlayer);
            this.secondPlayer.setState(SspStateImpl.outcomeToState(outcomeOfSecondPlayer));
            this.secondPlayer.setOutcome(outcomeOfSecondPlayer);
        }
    }

    private static PlayerState outcomeToState(Double outcome) {
        return outcome > 0.0 ? PlayerState.WON : (outcome < 0.0 ? PlayerState.LOST : PlayerState.DRAW);
    }
}

