package de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.random;

import java.util.Optional;
import java.util.Random;

import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaState;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMove;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaStrategy;

/**
 * Implements {@link IDilemmaStrategy} by randomly deciding answers.
 */
public class DilemmaRandomStrategy extends DilemmaStrategy {

    /**
     * Your personal entropy dealer - offering random bytes of excitement.
     */
    private static final Random RANDOM = new Random();

    /**
     * Creates an {@link DilemmaCooperateStrategy}.
     *
     * @param moveFactory The factory for creating Dilemma moves.
     */
    DilemmaRandomStrategy(final IDilemmaMoveFactory moveFactory) {
        super(moveFactory);
    }
    
    @Override
    public Optional<IDilemmaMove> computeNextMove(final int gameId,
            final IDilemmaPlayer player,
            final IDilemmaState state) {
        return Optional.of(RANDOM.nextBoolean()
            ? getMoveFactory().createCooperateMove()
            : getMoveFactory().createDefectMove());
    }

    @Override
    public String toString() {
        return DilemmaRandomStrategy.class.getSimpleName();
    }

    @Override
    public boolean equals(final Object object) {
        if (object instanceof DilemmaRandomStrategy) {
            final DilemmaRandomStrategy randomStrategy = (DilemmaRandomStrategy) object;
            return this.toString().equals(randomStrategy.toString());
        } else {
            return false;
        }
    }
    
    @Override
    public int hashCode() {
        return super.hashCode() * this.toString().hashCode();
    }
}