package de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.tit_for_tat;

import java.util.Optional;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaState;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMove;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaMemoryStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaRoundData;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaRoundPlayerData;
import de.fhdw.gaming.ipspiel23.memory.GameMemoryCapacity;
import de.fhdw.gaming.ipspiel23.memory.IGameMemory;
import de.fhdw.gaming.ipspiel23.memory.IGameMemoryCapacity;

/**
 * Cooperates on the first round and imitates its opponent's previous move thereafter.
 */
public class DilemmaTitForTatStrategy extends DilemmaMemoryStrategy {

    /**
     * Creates a new instance of the {@link DilemmaTitForTatStrategy} class.
     * @param moveFactory the move factory to use.
     */
    protected DilemmaTitForTatStrategy(final IDilemmaMoveFactory moveFactory) {
        super(moveFactory);
    }

    @Override
    public Optional<IDilemmaMove> computeNextMove(final int gameId, final IDilemmaPlayer player, 
            final IDilemmaState state)
            throws GameException, InterruptedException {
        final IGameMemory<DilemmaRoundData> memory = getMemoryForPlayer(player, state);
        final IDilemmaMoveFactory moveFactory = getMoveFactory();
        // cooperate on the first round ...
        if (memory.size() == 0) {
            return Optional.of(moveFactory.createCooperateMove());
        }
        // ...and imitate the opponent's previous move thereafter.
        final DilemmaRoundData previousRound = memory.getLatestRound();
        final DilemmaRoundPlayerData otherPlayersAction = previousRound.forOpponentOf(player);
        final IDilemmaMove myMove = moveFactory.sameAs(otherPlayersAction.move());
        return Optional.of(myMove);
    }

    @Override
    protected IGameMemoryCapacity requestedMemoryCapacity() {
        return GameMemoryCapacity.of(1);
    }
}
