/*
 * Copyright © 2021-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel24-GD.
 *
 * ipspiel24-GD is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * ipspiel24-GD is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel24-GD. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.GefangenenDilemma.domain.impl;

import java.util.Optional;

import de.fhdw.gaming.GefangenenDilemma.domain.GDMoveGenerator;
import de.fhdw.gaming.GefangenenDilemma.domain.GDPlayer;
import de.fhdw.gaming.GefangenenDilemma.domain.GDState;
import de.fhdw.gaming.GefangenenDilemma.moves.GDMove;
import de.fhdw.gaming.GefangenenDilemma.moves.factory.GDMoveFactory;
import de.fhdw.gaming.GefangenenDilemma.moves.impl.GDDefaultMoveFactory;

/**
 * Implements the {@link GDMoveGenerator} interface.
 */
final class GDMoveGeneratorImpl implements GDMoveGenerator {

    /**
     * The move factory.
     */
    private final GDMoveFactory moveFactory = new GDDefaultMoveFactory();

    @Override
    public Optional<GDMove> generate(final GDPlayer player,
            final GDState state) {
        // choose "no" to punish lame strategies
        return Optional.of(this.moveFactory.createSnitchMove());
    }
}
