/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.GefangenenDilemma.domain.impl;

import de.fhdw.gaming.GefangenenDilemma.domain.GDPlayer;
import de.fhdw.gaming.GefangenenDilemma.domain.impl.GDGameBuilderFactoryImpl;
import de.fhdw.gaming.core.domain.AbstractPlayer;
import de.fhdw.gaming.core.domain.Player;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;

final class GDPlayerImpl
extends AbstractPlayer<GDPlayer>
implements GDPlayer {
    private final Map<GDGameBuilderFactoryImpl.MOVES, Map<GDGameBuilderFactoryImpl.MOVES, Double>> possibleOutcomes;
    private Optional<GDGameBuilderFactoryImpl.MOVES> answer;
    private final Random random = new Random();

    GDPlayerImpl(String name, Map<GDGameBuilderFactoryImpl.MOVES, Map<GDGameBuilderFactoryImpl.MOVES, Double>> possibleOutcomes) {
        super(name);
        this.possibleOutcomes = Collections.unmodifiableMap(new LinkedHashMap<GDGameBuilderFactoryImpl.MOVES, Map<GDGameBuilderFactoryImpl.MOVES, Double>>(Objects.requireNonNull(possibleOutcomes, "possibleOutcomes")));
        this.answer = Optional.empty();
    }

    GDPlayerImpl(GDPlayer source) {
        super((Player)source);
        this.possibleOutcomes = source.getPossibleOutcomes();
        this.answer = source.getAnswer();
    }

    public String toString() {
        return String.format("GDPlayer[name=%s, state=%s, outcome=%s, answer=%s]", this.getName(), this.getState(), this.getOutcome(), this.answer);
    }

    public boolean equals(Object obj) {
        if (obj instanceof GDPlayerImpl) {
            GDPlayerImpl other = (GDPlayerImpl)obj;
            return super.equals(obj) && this.answer.equals(other.answer) && this.possibleOutcomes.equals(other.possibleOutcomes);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ Objects.hash(this.answer, this.possibleOutcomes);
    }

    @Override
    public Map<GDGameBuilderFactoryImpl.MOVES, Map<GDGameBuilderFactoryImpl.MOVES, Double>> getPossibleOutcomes() {
        return this.possibleOutcomes;
    }

    @Override
    public Optional<GDGameBuilderFactoryImpl.MOVES> getAnswer() {
        return this.answer;
    }

    @Override
    public void setAnswer(GDGameBuilderFactoryImpl.MOVES newAnswer) {
        if (this.answer.isPresent()) {
            throw new IllegalStateException(String.format("Player %s tried to change her answer.", this.getName()));
        }
        this.answer = Optional.of(newAnswer);
    }

    @Override
    public GDPlayer deepCopy() {
        return new GDPlayerImpl(this);
    }

    @Override
    public Random getRandom() {
        return this.random;
    }
}

