/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.ssp.strategy;

import de.fhdw.gaming.ipspiel24.ssp.domain.SspPlayer;
import de.fhdw.gaming.ipspiel24.ssp.domain.SspState;
import de.fhdw.gaming.ipspiel24.ssp.domain.SspStrategy;
import de.fhdw.gaming.ipspiel24.ssp.moves.SspMove;
import de.fhdw.gaming.ipspiel24.ssp.moves.factory.SspMoveFactory;
import java.util.Optional;
import java.util.Random;

public final class SspRandomStrategy
implements SspStrategy {
    private static Random random = new Random();
    private final SspMoveFactory moveFactory;

    SspRandomStrategy(SspMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public Optional<SspMove> computeNextMove(int gameId, SspPlayer player, SspState state, long maxComputationTimePerMove) {
        switch (random.nextInt(3)) {
            case 0: {
                return Optional.of(this.moveFactory.createPaperMove());
            }
            case 1: {
                return Optional.of(this.moveFactory.createRockMove());
            }
            case 2: {
                return Optional.of(this.moveFactory.createScissorsMove());
            }
        }
        throw new IllegalStateException();
    }

    public String toString() {
        return SspRandomStrategy.class.getSimpleName();
    }
}

