/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.tictactoe.strategy.random;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel24.tictactoe.core.domain.TicTacToeField;
import de.fhdw.gaming.ipspiel24.tictactoe.core.domain.TicTacToeFieldState;
import de.fhdw.gaming.ipspiel24.tictactoe.core.domain.TicTacToePlayer;
import de.fhdw.gaming.ipspiel24.tictactoe.core.domain.TicTacToeState;
import de.fhdw.gaming.ipspiel24.tictactoe.core.domain.TicTacToeStrategy;
import de.fhdw.gaming.ipspiel24.tictactoe.core.moves.TicTacToeMove;
import de.fhdw.gaming.ipspiel24.tictactoe.core.moves.factory.TicTacToeMoveFactory;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;

public final class TicTacToeRandomMoveStrategy
implements TicTacToeStrategy {
    private static final Random RANDOM = new Random();
    private final TicTacToeMoveFactory moveFactory;

    TicTacToeRandomMoveStrategy(TicTacToeMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public Optional<TicTacToeMove> computeNextMove(int gameId, TicTacToePlayer player, TicTacToeState state, long maxComputationTimePerMove) throws GameException {
        ArrayList fields = new ArrayList(state.getBoard().getFieldsBeing(TicTacToeFieldState.EMPTY).values());
        if (fields.isEmpty()) {
            return Optional.empty();
        }
        int index = RANDOM.nextInt(fields.size());
        TicTacToeField field = (TicTacToeField)fields.get(index);
        return Optional.of(this.moveFactory.createPlaceMarkMove(player.isUsingCrosses(), field.getPosition()));
    }

    public String toString() {
        return TicTacToeRandomMoveStrategy.class.getSimpleName();
    }
}

