/*
 * Copyright © 2021-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel24-VierConnects-gui.
 *
 * ipspiel24-VierConnects-gui is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * ipspiel24-VierConnects-gui is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * ipspiel24-VierConnects-gui. If not, see <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel24.VierConnects.gui.event;

import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsPosition;

/**
 * Represents an {@link VierConnectsBoardEvent} where the user selected a field to make a move.
 */
public final class VierConnectsMakeMoveBoardEvent implements VierConnectsBoardEvent {

    /**
     * The position of the field selected.
     */
    private final VierConnectsPosition fieldPosition;

    /**
     * Constructor.
     *
     * @param fieldPosition The position of the field selected.
     */
    public VierConnectsMakeMoveBoardEvent(final VierConnectsPosition fieldPosition) {
        this.fieldPosition = fieldPosition;
    }

    /**
     * Returns the position of the field selected.
     */
    public VierConnectsPosition getFieldPosition() {
        return this.fieldPosition;
    }

    @Override
    public void accept(final VierConnectsBoardEventVisitor visitor) {
        visitor.handleMakeMove(this);
    }
}
