package de.fhdw.gaming.ipspiel24.fg.domain;

import de.fhdw.gaming.core.domain.GameBuilderFactory;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.ui.InputProvider;

/**
 * A Demo {@link GameBuilderFactory} which allows to create a Freizeitgestaltung game builder.
 */
public interface FGGameBuilderFactory extends GameBuilderFactory {

    /**
     * Player's outcome on football/football.
     */
    String PARAM_PLAYER_OUTCOME_ON_FOOTBALL_FOOTBALL = "playerOutcomeOnFootballFootball";

    /**
     * Player's outcome on football/cinema.
     */
    String PARAM_PLAYER_OUTCOME_ON_FOOTBALL_CINEMA = "playerOutcomeOnFootballCinema";

    /**
     * Player's outcome on cinema/cinema.
     */
    String PARAM_PLAYER_OUTCOME_ON_CINEMA_CINEMA = "playerOutcomeOnCinemaCinema";

    /**
     * Player's outcome on Cinema/Football.
     */
    String PARAM_PLAYER_OUTCOME_ON_CINEMA_FOOTBALL = "playerOutcomeOnCinemaFootball";

    @Override
    FGGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException;
    
}
