/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.GefangenenDilemma.domain.impl;

import de.fhdw.gaming.GefangenenDilemma.domain.GDPlayer;
import de.fhdw.gaming.GefangenenDilemma.domain.GDPlayerBuilder;
import de.fhdw.gaming.GefangenenDilemma.domain.impl.GDGameBuilderFactoryImpl;
import de.fhdw.gaming.GefangenenDilemma.domain.impl.GDPlayerImpl;
import de.fhdw.gaming.core.domain.GameException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

final class GDPlayerBuilderImpl
implements GDPlayerBuilder {
    private Optional<String> name = Optional.empty();
    private Optional<Map<GDGameBuilderFactoryImpl.MOVES, Map<GDGameBuilderFactoryImpl.MOVES, Double>>> possibleOutcomes = Optional.empty();

    GDPlayerBuilderImpl() {
    }

    @Override
    public GDPlayerBuilderImpl changeName(String newName) {
        this.name = Optional.of(newName);
        return this;
    }

    @Override
    public GDPlayerBuilder changePossibleOutcomes(Map<GDGameBuilderFactoryImpl.MOVES, Map<GDGameBuilderFactoryImpl.MOVES, Double>> newPossibleOutcomes) {
        this.possibleOutcomes = Optional.of(newPossibleOutcomes);
        return this;
    }

    @Override
    public GDPlayer build() throws GameException {
        return new GDPlayerImpl(this.name.orElseThrow(), this.checkPossibleOutcomes(this.possibleOutcomes.orElseThrow()));
    }

    private Map<GDGameBuilderFactoryImpl.MOVES, Map<GDGameBuilderFactoryImpl.MOVES, Double>> checkPossibleOutcomes(Map<GDGameBuilderFactoryImpl.MOVES, Map<GDGameBuilderFactoryImpl.MOVES, Double>> outcomes) {
        this.checkPossibleOutcome(outcomes, GDGameBuilderFactoryImpl.MOVES.SNITCH, GDGameBuilderFactoryImpl.MOVES.SNITCH);
        this.checkPossibleOutcome(outcomes, GDGameBuilderFactoryImpl.MOVES.SNITCH, GDGameBuilderFactoryImpl.MOVES.REMAINSILENT);
        this.checkPossibleOutcome(outcomes, GDGameBuilderFactoryImpl.MOVES.REMAINSILENT, GDGameBuilderFactoryImpl.MOVES.SNITCH);
        this.checkPossibleOutcome(outcomes, GDGameBuilderFactoryImpl.MOVES.REMAINSILENT, GDGameBuilderFactoryImpl.MOVES.REMAINSILENT);
        return outcomes;
    }

    private void checkPossibleOutcome(Map<GDGameBuilderFactoryImpl.MOVES, Map<GDGameBuilderFactoryImpl.MOVES, Double>> outcomes, GDGameBuilderFactoryImpl.MOVES firstChoice, GDGameBuilderFactoryImpl.MOVES secondChoice) {
        if (outcomes.getOrDefault((Object)firstChoice, Collections.emptyMap()).get((Object)secondChoice) == null) {
            throw new IllegalArgumentException(String.format("No outcome defined for player '%s' and combination %s/%s.", this.name, GDPlayerBuilderImpl.toString(firstChoice), GDPlayerBuilderImpl.toString(secondChoice)));
        }
    }

    private static String toString(GDGameBuilderFactoryImpl.MOVES value) {
        switch (value) {
            case SNITCH: {
                return "SNITCH";
            }
            case REMAINSILENT: {
                return "REMAINSILENT";
            }
        }
        return "NaN";
    }
}

