/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.GefangenenDilemma.domain.impl;

import de.fhdw.gaming.GefangenenDilemma.domain.GDGameBuilder;
import de.fhdw.gaming.GefangenenDilemma.domain.GDPlayer;
import de.fhdw.gaming.GefangenenDilemma.domain.GDPlayerBuilder;
import de.fhdw.gaming.GefangenenDilemma.domain.GDState;
import de.fhdw.gaming.GefangenenDilemma.domain.GDStrategy;
import de.fhdw.gaming.GefangenenDilemma.domain.impl.GDMoveGeneratorImpl;
import de.fhdw.gaming.GefangenenDilemma.domain.impl.GDPlayerBuilderImpl;
import de.fhdw.gaming.GefangenenDilemma.domain.impl.GDStateImpl;
import de.fhdw.gaming.GefangenenDilemma.moves.GDMove;
import de.fhdw.gaming.GefangenenDilemma.moves.impl.AbstractGDMove;
import de.fhdw.gaming.core.domain.DefaultGame;
import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.MoveGenerator;
import de.fhdw.gaming.core.domain.Observer;
import de.fhdw.gaming.core.domain.State;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

final class GDGameBuilderImpl
implements GDGameBuilder {
    private final List<Observer> observers = new ArrayList<Observer>();
    private Optional<GDPlayer> firstPlayer = Optional.empty();
    private Optional<GDStrategy> firstPlayerStrategy = Optional.empty();
    private Optional<GDPlayer> secondPlayer = Optional.empty();
    private Optional<GDStrategy> secondPlayerStrategy = Optional.empty();
    private int maxComputationTimePerMove = 5;

    GDGameBuilderImpl() {
    }

    @Override
    public GDPlayerBuilder createPlayerBuilder() {
        return new GDPlayerBuilderImpl();
    }

    @Override
    public GDGameBuilder addPlayer(GDPlayer player, GDStrategy strategy) throws GameException {
        if (this.firstPlayer.isEmpty()) {
            this.firstPlayer = Optional.of(Objects.requireNonNull(player, "player"));
            this.firstPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "firstPlayerStrategy"));
        } else if (this.secondPlayer.isEmpty()) {
            this.secondPlayer = Optional.of(Objects.requireNonNull(player, "player"));
            this.secondPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "secondPlayerStrategy"));
        } else {
            throw new GameException(String.format("More than two players are now allowed.", new Object[0]));
        }
        return this;
    }

    public GDGameBuilder changeMaximumComputationTimePerMove(int newMaxComputationTimePerMove) {
        this.maxComputationTimePerMove = newMaxComputationTimePerMove;
        return this;
    }

    @Override
    public GDGameBuilder addObservers(List<Observer> newObservers) {
        this.observers.addAll(newObservers);
        return this;
    }

    @Override
    public Game<GDPlayer, GDState, GDMove, GDStrategy> build(int id) throws GameException, InterruptedException {
        if (!this.firstPlayer.isPresent() || !this.secondPlayer.isPresent()) {
            throw new GameException("A Gefangenen-Dilemma game needs two players.");
        }
        GDStateImpl initialState = new GDStateImpl(this.firstPlayer.get(), this.secondPlayer.get());
        LinkedHashMap<String, GDStrategy> strategies = new LinkedHashMap<String, GDStrategy>();
        strategies.put(initialState.getFirstPlayer().getName(), this.firstPlayerStrategy.orElseThrow());
        strategies.put(initialState.getSecondPlayer().getName(), this.secondPlayerStrategy.orElseThrow());
        return new DefaultGame(id, (State)initialState, strategies, (long)this.maxComputationTimePerMove, AbstractGDMove.class::isInstance, (MoveGenerator)new GDMoveGeneratorImpl(), this.observers);
    }
}

