/*
 * Copyright © 2021-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel24-Ssp.
 *
 * Ipspiel24-Ssp is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel24-Ssp is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel24-Ssp. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel24.ssp.strategy;

import java.util.Optional;

import de.fhdw.gaming.ipspiel24.ssp.domain.SspPlayer;
import de.fhdw.gaming.ipspiel24.ssp.domain.SspState;
import de.fhdw.gaming.ipspiel24.ssp.domain.SspStrategy;
import de.fhdw.gaming.ipspiel24.ssp.moves.SspMove;
import de.fhdw.gaming.ipspiel24.ssp.moves.factory.SspMoveFactory;
import java.util.Random;

/**
 * Implements {@link SspStrategy} by always choosing random.
 */
public final class SspRandomStrategy implements SspStrategy {

    /**
     * Generates random number.
     */
    private static Random random = new Random();
    /**
     * The factory for creating Ssp moves.
     */
    private final SspMoveFactory moveFactory;

    /**
     * Creates an {@link SspRandomStrategy}.
     *
     * @param moveFactory The factory for creating Ssp moves.
     */
    SspRandomStrategy(final SspMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
    public Optional<SspMove> computeNextMove(
            final int gameId,
            final SspPlayer player,
            final SspState state,
            final long maxComputationTimePerMove) {

        switch (random.nextInt(3)) {
        case 0:
            return Optional.of(this.moveFactory.createPaperMove());
        case 1:
            return Optional.of(this.moveFactory.createRockMove());
        case 2:
            return Optional.of(this.moveFactory.createScissorsMove());
        default:
            throw new IllegalStateException();
        }
    }

    @Override
    public String toString() {
        return SspRandomStrategy.class.getSimpleName();
    }
}
