/*
 * Copyright © 2021-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel24-GD.
 *
 * Ipspiel24-GD is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel24-GD is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel24-ipspiel24-GD. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.GefangenenDilemma.domain;

import de.fhdw.gaming.core.domain.GameBuilderFactory;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.ui.InputProvider;

/**
 * A Gefangenen-Dilemma {@link GameBuilderFactory} which allows to create a Gefangenen-Dilemma game builder.
 */
public interface GDGameBuilderFactory extends GameBuilderFactory {

    /**
     * Player's outcome on no/no.
     */
    String OUTCOME_ON_SNITCH_SNITCH = "playerOutcomeOnSnitchSnitch";

    /**
     * Player's outcome on no/yes.
     */
    String OUTCOME_ON_SNITCH_REMAINSILENT = "playerOutcomeOnSnitchRemainSilent";

    /**
     * Player's outcome on no/no.
     */
    String OUTCOME_ON_REMAINSILENT_SNITCH = "playerOutcomeOnRemainSilentSnitch";

    /**
     * Player's outcome on no/yes.
     */
    String OUTCOME_ON_REMAINSILENT_REMAINSILENT = "playerOutcomeOnRemainSilentRemainSilent";

    @Override
    GDGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException;
}
