/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.VierConnects.gui.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsPlayer;
import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsState;
import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsStrategy;
import de.fhdw.gaming.ipspiel24.VierConnects.core.moves.VierConnectsMove;
import de.fhdw.gaming.ipspiel24.VierConnects.core.moves.factory.VierConnectsMoveFactory;
import de.fhdw.gaming.ipspiel24.VierConnects.gui.VierConnectsBoardEventProvider;
import de.fhdw.gaming.ipspiel24.VierConnects.gui.impl.VierConnectsGuiObserverImpl;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public final class VierConnectsInteractiveStrategy
implements VierConnectsStrategy {
    private final VierConnectsMoveFactory moveFactory;

    VierConnectsInteractiveStrategy(VierConnectsMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public Optional<VierConnectsMove> computeNextMove(int gameId, VierConnectsPlayer player, VierConnectsState state, long maxComputationTimePerMove) throws GameException {
        Optional<VierConnectsBoardEventProvider> provider = VierConnectsGuiObserverImpl.getEventProvider(gameId);
        if (provider.isEmpty()) {
            return Optional.empty();
        }
        AtomicReference move = new AtomicReference();
        provider.get().waitForEvent(player, state).accept(event -> move.setPlain(this.moveFactory.createPlaceMarkMove(player.isUsingCrosses(), event.getFieldPosition().getColumn())));
        return Optional.ofNullable((VierConnectsMove)move.getPlain());
    }

    public String toString() {
        return VierConnectsInteractiveStrategy.class.getSimpleName();
    }

    public boolean isInteractive() {
        return true;
    }

    public void abortRequested(int gameId) {
        Optional<VierConnectsBoardEventProvider> provider = VierConnectsGuiObserverImpl.getEventProvider(gameId);
        if (!provider.isEmpty()) {
            provider.get().cancelWaiting();
        }
    }
}

