/*
 * Copyright © 2021-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel24-VierConnects-strategy-random.
 *
 * ipspiel24-VierConnects-strategy-random is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * ipspiel24-VierConnects-strategy-random is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * ipspiel24-VierConnects-strategy-random. If not, see <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel24.VierConnects.strategy.random;

import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsStrategy;
import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.factory.VierConnectsStrategyFactory;
import de.fhdw.gaming.ipspiel24.VierConnects.core.moves.factory.VierConnectsMoveFactory;

/**
 * Implements {@link VierConnectsStrategyFactory}.
 */
public final class VierConnectsRandomMoveStrategyFactory implements VierConnectsStrategyFactory {

    @Override
    public VierConnectsStrategy create(final VierConnectsMoveFactory moveFactory) {
        return new VierConnectsRandomMoveStrategy(moveFactory);
    }
}
