/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.fg.strategy;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel24.fg.domain.FGPlayer;
import de.fhdw.gaming.ipspiel24.fg.domain.FGState;
import de.fhdw.gaming.ipspiel24.fg.domain.FGStrategy;
import de.fhdw.gaming.ipspiel24.fg.moves.FGMove;
import de.fhdw.gaming.ipspiel24.fg.moves.factory.FGMoveFactory;
import java.security.SecureRandom;
import java.util.Optional;

public class FGmixedMoveStrategy
implements FGStrategy {
    private final FGMoveFactory moveFactory;
    private final SecureRandom random;

    FGmixedMoveStrategy(FGMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
        this.random = new SecureRandom();
    }

    public Optional<FGMove> computeNextMove(int gameId, FGPlayer player, FGState state, long maxComputationTimePerMove) throws GameException, InterruptedException {
        double rand = this.random.nextInt(3);
        if (state.getFirstPlayer().equals(player)) {
            if (rand < 2.0) {
                return Optional.of(this.moveFactory.createFootballMove());
            }
            return Optional.of(this.moveFactory.createCinemaMove());
        }
        if (rand >= 2.0) {
            return Optional.of(this.moveFactory.createFootballMove());
        }
        return Optional.of(this.moveFactory.createCinemaMove());
    }

    public String toString() {
        return FGmixedMoveStrategy.class.getSimpleName();
    }
}

