/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.fg.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel24.fg.domain.FGActivity;
import de.fhdw.gaming.ipspiel24.fg.domain.FGPlayer;
import de.fhdw.gaming.ipspiel24.fg.domain.FGPlayerBuilder;
import de.fhdw.gaming.ipspiel24.fg.domain.impl.FGPlayerImpl;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

final class FGPlayerBuilderImpl
implements FGPlayerBuilder {
    private Optional<String> name = Optional.empty();
    private Optional<Map<FGActivity, Map<FGActivity, Double>>> possibleOutcomes = Optional.empty();

    FGPlayerBuilderImpl() {
    }

    @Override
    public FGPlayerBuilderImpl changeName(String newName) {
        this.name = Optional.of(newName);
        return this;
    }

    @Override
    public FGPlayerBuilder changePossibleOutcomes(Map<FGActivity, Map<FGActivity, Double>> newPossibleOutcomes) {
        this.possibleOutcomes = Optional.of(newPossibleOutcomes);
        return this;
    }

    @Override
    public FGPlayer build() throws GameException {
        return new FGPlayerImpl(this.name.orElseThrow(), this.checkPossibleOutcomes(this.possibleOutcomes.orElseThrow()));
    }

    private Map<FGActivity, Map<FGActivity, Double>> checkPossibleOutcomes(Map<FGActivity, Map<FGActivity, Double>> outcomes) {
        this.checkPossibleOutcome(outcomes, FGActivity.FOOTBALL, FGActivity.FOOTBALL);
        this.checkPossibleOutcome(outcomes, FGActivity.FOOTBALL, FGActivity.CINEMA);
        this.checkPossibleOutcome(outcomes, FGActivity.CINEMA, FGActivity.FOOTBALL);
        this.checkPossibleOutcome(outcomes, FGActivity.CINEMA, FGActivity.CINEMA);
        return outcomes;
    }

    private void checkPossibleOutcome(Map<FGActivity, Map<FGActivity, Double>> outcomes, FGActivity firstChoice, FGActivity secondChoice) {
        if (outcomes.getOrDefault((Object)firstChoice, Collections.emptyMap()).get((Object)secondChoice) == null) {
            throw new IllegalArgumentException(String.format("No outcome defined for player '%s' and combination %s/%s.", this.name, FGPlayerBuilderImpl.toAnswer(firstChoice), FGPlayerBuilderImpl.toAnswer(secondChoice)));
        }
    }

    private static String toAnswer(FGActivity value) {
        return value.equals((Object)FGActivity.CINEMA) ? "cinema" : "football";
    }
}

