/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.fg.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.ipspiel24.fg.domain.FGActivity;
import de.fhdw.gaming.ipspiel24.fg.domain.FGPlayer;
import de.fhdw.gaming.ipspiel24.fg.domain.FGState;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class FGStateImpl
implements FGState {
    private final FGPlayer firstPlayer;
    private final FGPlayer secondPlayer;

    FGStateImpl(FGPlayer firstPlayer, FGPlayer secondPlayer) throws GameException {
        this.firstPlayer = Objects.requireNonNull(firstPlayer, "firstPlayer");
        this.secondPlayer = Objects.requireNonNull(secondPlayer, "secondPlayer");
        if (this.firstPlayer.getName().equals(this.secondPlayer.getName())) {
            throw new IllegalArgumentException(String.format("Both players have the same name '%s'.", this.firstPlayer.getName()));
        }
    }

    FGStateImpl(FGStateImpl source) {
        this.firstPlayer = source.firstPlayer.deepCopy();
        this.secondPlayer = source.secondPlayer.deepCopy();
    }

    @Override
    public FGPlayer getFirstPlayer() {
        return this.firstPlayer;
    }

    @Override
    public FGPlayer getSecondPlayer() {
        return this.secondPlayer;
    }

    public String toString() {
        return String.format("FGState[firstPlayer=%s, secondPlayer=%s]", this.firstPlayer, this.secondPlayer);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FGStateImpl) {
            FGStateImpl other = (FGStateImpl)obj;
            return this.firstPlayer.equals(other.firstPlayer) && this.secondPlayer.equals(other.secondPlayer);
        }
        return false;
    }

    public FGState deepCopy() {
        return new FGStateImpl(this);
    }

    public int hashCode() {
        return Objects.hash(this.firstPlayer, this.secondPlayer);
    }

    public Map<String, FGPlayer> getPlayers() {
        LinkedHashMap<String, FGPlayer> result = new LinkedHashMap<String, FGPlayer>();
        result.put(this.firstPlayer.getName(), this.firstPlayer);
        result.put(this.secondPlayer.getName(), this.secondPlayer);
        return result;
    }

    public Set<FGPlayer> computeNextPlayers() {
        LinkedHashSet<FGPlayer> playersWithoutMove = new LinkedHashSet<FGPlayer>();
        if (this.firstPlayer.getAnswer().isEmpty()) {
            playersWithoutMove.add(this.firstPlayer);
        }
        if (this.secondPlayer.getAnswer().isEmpty()) {
            playersWithoutMove.add(this.secondPlayer);
        }
        return playersWithoutMove;
    }

    public void nextTurn() {
        Set<FGPlayer> playersWithoutMove = this.computeNextPlayers();
        if (playersWithoutMove.isEmpty()) {
            FGActivity answerOfFirstPlayer = this.firstPlayer.getAnswer().orElseThrow();
            FGActivity answerOfSecondPlayer = this.secondPlayer.getAnswer().orElseThrow();
            Double outcomeOfFirstPlayer = this.firstPlayer.getPossibleOutcomes().get((Object)answerOfFirstPlayer).get((Object)answerOfSecondPlayer);
            this.firstPlayer.setState(FGStateImpl.outcomeToState(outcomeOfFirstPlayer));
            this.firstPlayer.setOutcome(outcomeOfFirstPlayer);
            Double outcomeOfSecondPlayer = this.secondPlayer.getPossibleOutcomes().get((Object)answerOfFirstPlayer).get((Object)answerOfSecondPlayer);
            this.secondPlayer.setState(FGStateImpl.outcomeToState(outcomeOfSecondPlayer));
            this.secondPlayer.setOutcome(outcomeOfSecondPlayer);
        }
    }

    private static PlayerState outcomeToState(Double outcome) {
        return outcome > 0.0 ? PlayerState.WON : (outcome < 0.0 ? PlayerState.LOST : PlayerState.DRAW);
    }
}

