/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.fg.domain.impl;

import de.fhdw.gaming.core.domain.DefaultGame;
import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.MoveGenerator;
import de.fhdw.gaming.core.domain.Observer;
import de.fhdw.gaming.core.domain.State;
import de.fhdw.gaming.ipspiel24.fg.domain.FGGameBuilder;
import de.fhdw.gaming.ipspiel24.fg.domain.FGPlayer;
import de.fhdw.gaming.ipspiel24.fg.domain.FGPlayerBuilder;
import de.fhdw.gaming.ipspiel24.fg.domain.FGState;
import de.fhdw.gaming.ipspiel24.fg.domain.FGStrategy;
import de.fhdw.gaming.ipspiel24.fg.domain.impl.FGMoveGeneratorImpl;
import de.fhdw.gaming.ipspiel24.fg.domain.impl.FGPlayerBuilderImpl;
import de.fhdw.gaming.ipspiel24.fg.domain.impl.FGStateImpl;
import de.fhdw.gaming.ipspiel24.fg.moves.FGMove;
import de.fhdw.gaming.ipspiel24.fg.moves.impl.AbstractFGMove;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

final class FGGameBuilderImpl
implements FGGameBuilder {
    private final List<Observer> observers = new ArrayList<Observer>();
    private Optional<FGPlayer> firstPlayer = Optional.empty();
    private Optional<FGStrategy> firstPlayerStrategy = Optional.empty();
    private Optional<FGPlayer> secondPlayer = Optional.empty();
    private Optional<FGStrategy> secondPlayerStrategy = Optional.empty();
    private int maxComputationTimePerMove = 5;

    FGGameBuilderImpl() {
    }

    @Override
    public FGPlayerBuilder createPlayerBuilder() {
        return new FGPlayerBuilderImpl();
    }

    @Override
    public FGGameBuilder addPlayer(FGPlayer player, FGStrategy strategy) throws GameException {
        if (this.firstPlayer.isEmpty()) {
            this.firstPlayer = Optional.of(Objects.requireNonNull(player, "player"));
            this.firstPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "firstPlayerStrategy"));
        } else if (this.secondPlayer.isEmpty()) {
            this.secondPlayer = Optional.of(Objects.requireNonNull(player, "player"));
            this.secondPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "secondPlayerStrategy"));
        } else {
            throw new GameException(String.format("More than two players are now allowed.", new Object[0]));
        }
        return this;
    }

    public FGGameBuilder changeMaximumComputationTimePerMove(int newMaxComputationTimePerMove) {
        this.maxComputationTimePerMove = newMaxComputationTimePerMove;
        return this;
    }

    @Override
    public FGGameBuilder addObservers(List<Observer> newObservers) {
        this.observers.addAll(newObservers);
        return this;
    }

    @Override
    public Game<FGPlayer, FGState, FGMove, FGStrategy> build(int id) throws GameException, InterruptedException {
        if (!this.firstPlayer.isPresent() || !this.secondPlayer.isPresent()) {
            throw new GameException("A FG game needs two players.");
        }
        FGStateImpl initialState = new FGStateImpl(this.firstPlayer.get(), this.secondPlayer.get());
        LinkedHashMap<String, FGStrategy> strategies = new LinkedHashMap<String, FGStrategy>();
        strategies.put(initialState.getFirstPlayer().getName(), this.firstPlayerStrategy.orElseThrow());
        strategies.put(initialState.getSecondPlayer().getName(), this.secondPlayerStrategy.orElseThrow());
        return new DefaultGame(id, (State)initialState, strategies, (long)this.maxComputationTimePerMove, AbstractFGMove.class::isInstance, (MoveGenerator)new FGMoveGeneratorImpl(), this.observers);
    }
}

