package de.fhdw.gaming.ipspiel24.minimax;

import java.util.List;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;

/**
 * TODO missing comment.
 *
 * @param <P> TODO
 * @param <S> TODO
 * @param <M> TODO
 */
public class Minimax<P extends Player<P>, S extends State<P, S>, M extends Move<P, S>> {

    /**
     * TODO missing comment.
     */
    private final int maxDepth;
    /**
     * TODO missing comment.
     */
    private final MinimaxStrategy<P, S, M> strategy;
    /**
     * TODO missing comment.
     */
    private final P opponent;

    /**
     * TODO missing comment.
     *
     * @param strategy TODO
     * @param maxDepth TODO
     * @param opponent TODO
     */
    public Minimax(final MinimaxStrategy<P, S, M> strategy, final int maxDepth, final P opponent) {
        this.strategy = strategy;
        this.maxDepth = maxDepth;
        this.opponent = opponent;
    }

    /**
     * TODO missing comment.
     *
     * @param state  TODO
     * @param player TODO
     */
    public M getBestMove(final S state, final P player) throws GameException {
        final List<M> possibleMoves = this.strategy.getPossibleMoves(state);
        if (possibleMoves.isEmpty()) {
            return null;
        }

        int bestScore = Integer.MIN_VALUE + 1;
        M bestMove = null;
        for (final M move : possibleMoves) {
            final S stateCopy = state.deepCopy();
            move.applyTo(stateCopy, player);
            stateCopy.nextTurn();
            final int score = -this.negamax(stateCopy, player, this.maxDepth, Integer.MIN_VALUE + 1, Integer.MAX_VALUE,
                    false);
            System.out.println("score Move: " + score + " for " + move.toString());
            if (score > bestScore) {
                bestScore = score;
                bestMove = move;
            }
        }
        System.out.println("ALL MOVES EVALUATED, best Score: " + bestScore);
        return bestMove;
    }

    /**
     * negamax algorithm.
     *
     * @param state        of game
     * @param player       player
     * @param depth        maxdepth of game tree
     * @param alpha        lower bound of range for ab-pruning
     * @param beta         upper bound for pruning
     * @param isMaximising whether the minimizing player or maximising players turn
     * @return score of individual path.
     * @throws GameException
     */
    private int negamax(final S state, final P player, final int depth, final int alpha, final int beta,
            final boolean isMaximising) throws GameException {
        int newAlpha = alpha;
        final int newBeta = beta;

        final int evaluation = this.strategy.evaluate(state, player, depth);
        if (depth == 0 || Math.abs(evaluation) > 0 || this.strategy.getPossibleMoves(state).isEmpty()) {
            return evaluation * (isMaximising ? 1 : -1);
        }

        int bestValue = Integer.MIN_VALUE + 1;
        // System.out.println("isMaximising: " + isMaximising + " ------------------");
        for (final M move : this.strategy.getPossibleMoves(state)) {
            final S stateCopy = state.deepCopy();
            move.applyTo(stateCopy, isMaximising ? player : this.opponent);
            stateCopy.nextTurn();
            // System.out.println(move.toString());
            final int value = -this.negamax(stateCopy, player, depth - 1, -newBeta,
                    -newAlpha, !isMaximising);
            // System.out.println("negamx value: " + value);
            bestValue = Math.max(bestValue, value);
            newAlpha = Math.max(newAlpha, bestValue);

            if (newAlpha >= newBeta) {
                break;
            }

        }

        return bestValue;
    }
}
