/*
 * Copyright © 2020-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of othello-core.
 *
 * Othello-core is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Othello-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with othello-core.  If not, see <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel24.muenzwurf.core.domain;

import java.util.Map;

import de.fhdw.gaming.core.domain.GameException;

/**
 * A builder which allows to create a Demo player.
 */
public interface MuenzwurfPlayerBuilder {

    /**
     * Changes the name of the player.
     * <p>
     * There is no default.
     *
     * @param newName The name of the player.
     * @return {@code this}
     */
    MuenzwurfPlayerBuilder changeName(String newName);

    /**
     * Builds the player.
     *
     * @return The Muenzwurf player.
     * @throws GameException if creating the player is not allowed by the rules of the game.
     */
    MuenzwurfPlayer build() throws GameException;
    
    /**
     * Changes the possible outcome.
     *
     * @param newPossibleOutcomes The new outcome.
     * @throws GameException if creating the player is not allowed by the rules of the game.
     */
    MuenzwurfPlayerBuilder changePossibleOutcomes(Map<MuenzwurfSide,
            Map<MuenzwurfSide, Double>>newPossibleOutcomes);
}
