/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfPlayer;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfSide;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfState;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class MuenzwurfStateImpl
implements MuenzwurfState {
    private final MuenzwurfPlayer firstPlayer;
    private final MuenzwurfPlayer secondPlayer;

    MuenzwurfStateImpl(MuenzwurfPlayer firstPlayer, MuenzwurfPlayer secondPlayer) throws GameException {
        this.firstPlayer = Objects.requireNonNull(firstPlayer, "firstPlayer");
        this.secondPlayer = Objects.requireNonNull(secondPlayer, "secondPlayer");
        if (this.firstPlayer.getName().equals(this.secondPlayer.getName())) {
            throw new IllegalArgumentException(String.format("Both players have the same name '%s'.", this.firstPlayer.getName()));
        }
    }

    MuenzwurfStateImpl(MuenzwurfStateImpl source) {
        this.firstPlayer = source.firstPlayer.deepCopy();
        this.secondPlayer = source.secondPlayer.deepCopy();
    }

    @Override
    public MuenzwurfPlayer getFirstPlayer() {
        return this.firstPlayer;
    }

    @Override
    public MuenzwurfPlayer getSecondPlayer() {
        return this.secondPlayer;
    }

    public String toString() {
        return String.format("MuenzwurfState[firstPlayer=%s, secondPlayer=%s]", this.firstPlayer, this.secondPlayer);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MuenzwurfStateImpl) {
            MuenzwurfStateImpl other = (MuenzwurfStateImpl)obj;
            return this.firstPlayer.equals(other.firstPlayer) && this.secondPlayer.equals(other.secondPlayer);
        }
        return false;
    }

    public MuenzwurfState deepCopy() {
        return new MuenzwurfStateImpl(this);
    }

    public int hashCode() {
        return Objects.hash(this.firstPlayer, this.secondPlayer);
    }

    public Map<String, MuenzwurfPlayer> getPlayers() {
        LinkedHashMap<String, MuenzwurfPlayer> result = new LinkedHashMap<String, MuenzwurfPlayer>();
        result.put(this.firstPlayer.getName(), this.firstPlayer);
        result.put(this.secondPlayer.getName(), this.secondPlayer);
        return result;
    }

    public Set<MuenzwurfPlayer> computeNextPlayers() {
        LinkedHashSet<MuenzwurfPlayer> playersWithoutMove = new LinkedHashSet<MuenzwurfPlayer>();
        if (this.firstPlayer.getSide().isEmpty()) {
            playersWithoutMove.add(this.firstPlayer);
        }
        if (this.secondPlayer.getSide().isEmpty()) {
            playersWithoutMove.add(this.secondPlayer);
        }
        return playersWithoutMove;
    }

    public void nextTurn() {
        Set<MuenzwurfPlayer> playersWithoutMove = this.computeNextPlayers();
        if (playersWithoutMove.isEmpty()) {
            MuenzwurfSide answerOfFirstPlayer = this.firstPlayer.getSide().orElseThrow();
            MuenzwurfSide answerOfSecondPlayer = this.secondPlayer.getSide().orElseThrow();
            Double outcomeOfFirstPlayer = this.firstPlayer.getPossibleOutcomes().get((Object)answerOfFirstPlayer).get((Object)answerOfSecondPlayer);
            this.firstPlayer.setState(MuenzwurfStateImpl.outcomeToState(outcomeOfFirstPlayer));
            this.firstPlayer.setOutcome(outcomeOfFirstPlayer);
            Double outcomeOfSecondPlayer = this.secondPlayer.getPossibleOutcomes().get((Object)answerOfFirstPlayer).get((Object)answerOfSecondPlayer);
            this.secondPlayer.setState(MuenzwurfStateImpl.outcomeToState(outcomeOfSecondPlayer));
            this.secondPlayer.setOutcome(outcomeOfSecondPlayer);
        }
    }

    private static PlayerState outcomeToState(Double outcome) {
        return outcome > 0.0 ? PlayerState.WON : (outcome < 0.0 ? PlayerState.LOST : PlayerState.DRAW);
    }
}

