/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.ssp.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel24.ssp.domain.SspPlayer;
import de.fhdw.gaming.ipspiel24.ssp.domain.SspPlayerBuilder;
import de.fhdw.gaming.ipspiel24.ssp.domain.SspPossibleChoice;
import de.fhdw.gaming.ipspiel24.ssp.domain.impl.SspPlayerImpl;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

final class SspPlayerBuilderImpl
implements SspPlayerBuilder {
    private Optional<String> name = Optional.empty();
    private Optional<Map<SspPossibleChoice, Map<SspPossibleChoice, Double>>> possibleOutcomes = Optional.empty();

    SspPlayerBuilderImpl() {
    }

    @Override
    public SspPlayerBuilderImpl changeName(String newName) {
        this.name = Optional.of(newName);
        return this;
    }

    @Override
    public SspPlayerBuilder changePossibleOutcomes(Map<SspPossibleChoice, Map<SspPossibleChoice, Double>> newPossibleOutcomes) {
        this.possibleOutcomes = Optional.of(newPossibleOutcomes);
        return this;
    }

    @Override
    public SspPlayer build() throws GameException {
        return new SspPlayerImpl(this.name.orElseThrow(), this.checkPossibleOutcomes(this.possibleOutcomes.orElseThrow()));
    }

    private Map<SspPossibleChoice, Map<SspPossibleChoice, Double>> checkPossibleOutcomes(Map<SspPossibleChoice, Map<SspPossibleChoice, Double>> outcomes) {
        this.checkPossibleOutcome(outcomes, SspPossibleChoice.SPC_ROCK, SspPossibleChoice.SPC_ROCK);
        this.checkPossibleOutcome(outcomes, SspPossibleChoice.SPC_ROCK, SspPossibleChoice.SPC_PAPER);
        this.checkPossibleOutcome(outcomes, SspPossibleChoice.SPC_ROCK, SspPossibleChoice.SPC_SCISSORS);
        this.checkPossibleOutcome(outcomes, SspPossibleChoice.SPC_PAPER, SspPossibleChoice.SPC_PAPER);
        this.checkPossibleOutcome(outcomes, SspPossibleChoice.SPC_PAPER, SspPossibleChoice.SPC_SCISSORS);
        this.checkPossibleOutcome(outcomes, SspPossibleChoice.SPC_PAPER, SspPossibleChoice.SPC_ROCK);
        this.checkPossibleOutcome(outcomes, SspPossibleChoice.SPC_SCISSORS, SspPossibleChoice.SPC_SCISSORS);
        this.checkPossibleOutcome(outcomes, SspPossibleChoice.SPC_SCISSORS, SspPossibleChoice.SPC_ROCK);
        this.checkPossibleOutcome(outcomes, SspPossibleChoice.SPC_SCISSORS, SspPossibleChoice.SPC_PAPER);
        return outcomes;
    }

    private void checkPossibleOutcome(Map<SspPossibleChoice, Map<SspPossibleChoice, Double>> outcomes, SspPossibleChoice firstChoice, SspPossibleChoice secondChoice) {
        if (outcomes.getOrDefault((Object)firstChoice, Collections.emptyMap()).get((Object)secondChoice) == null) {
            throw new IllegalArgumentException(String.format("No outcome defined for player '%s' and combination %s/%s.", this.name, SspPlayerBuilderImpl.toAnswer(firstChoice), SspPlayerBuilderImpl.toAnswer(secondChoice)));
        }
    }

    private static String toAnswer(SspPossibleChoice value) {
        switch (value) {
            case SPC_ROCK: {
                return "Rock";
            }
            case SPC_PAPER: {
                return "Paper";
            }
            case SPC_SCISSORS: {
                return "Scissors";
            }
        }
        return "default";
    }
}

