/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.VierConnects.strategy.minimax;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;
import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsBoard;
import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsFieldState;
import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsPlayer;
import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsPosition;
import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsState;
import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsStrategy;
import de.fhdw.gaming.ipspiel24.VierConnects.core.moves.VierConnectsMove;
import de.fhdw.gaming.ipspiel24.VierConnects.core.moves.factory.VierConnectsMoveFactory;
import de.fhdw.gaming.ipspiel24.minimax.Minimax;
import de.fhdw.gaming.ipspiel24.minimax.MinimaxStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class VierConnectsMinimaxStrategy
implements VierConnectsStrategy,
MinimaxStrategy<VierConnectsPlayer, VierConnectsState, VierConnectsMove> {
    private final VierConnectsMoveFactory moveFactory;
    private final int maxDepth = 5;
    private final int scoreCenterCountMultiplier = 2;
    private final int scoreWin = 999999;
    private final int score3Row = 100;
    private final int score2Row = 50;
    private final int scoreLose = 99999;
    private final int score3RowEnemy = 100;

    public VierConnectsMinimaxStrategy(VierConnectsMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public Optional<VierConnectsMove> computeNextMove(int gameId, VierConnectsPlayer player, VierConnectsState state, long maxComputationTimePerMove) throws GameException, InterruptedException {
        VierConnectsPlayer opponent = this.getOpponent(state);
        Minimax minimax = new Minimax((MinimaxStrategy)this, this.maxDepth, (Player)opponent);
        VierConnectsMove bestMove = (VierConnectsMove)minimax.getBestMove((State)state, (Player)player);
        return Optional.of(bestMove);
    }

    public List<VierConnectsMove> getPossibleMoves(VierConnectsState state) {
        ArrayList<VierConnectsMove> possibleMoves = new ArrayList<VierConnectsMove>();
        VierConnectsBoard board = state.getBoard();
        for (int i = 0; i < board.getColumnSize(); ++i) {
            VierConnectsPosition pos = VierConnectsPosition.of((int)0, (int)i);
            if (board.getFieldAt(pos).getState() != VierConnectsFieldState.EMPTY) continue;
            possibleMoves.add(this.moveFactory.createPlaceMarkMove(state.getCurrentPlayer().isUsingCrosses(), i));
        }
        return this.orderMoves(possibleMoves);
    }

    private List<VierConnectsMove> orderMoves(List<VierConnectsMove> possibleMoves) {
        ArrayList<VierConnectsMove> orderedMoves = new ArrayList<VierConnectsMove>(possibleMoves.size());
        int middle = possibleMoves.size() / 2;
        for (int i = 0; i < possibleMoves.size(); ++i) {
            int index = middle + (i % 2 == 0 ? i / 2 : -(i / 2 + 1));
            orderedMoves.add(possibleMoves.get(index));
        }
        return orderedMoves;
    }

    private int evaluateWindow(VierConnectsFieldState[] window, VierConnectsFieldState playerState) {
        int score = 0;
        VierConnectsFieldState opponent = this.getOpponent(playerState);
        long playerCount = Arrays.stream(window).filter(p -> p == playerState).count();
        long opponentCount = Arrays.stream(window).filter(p -> p == opponent).count();
        long emptyCount = Arrays.stream(window).filter(p -> p == VierConnectsFieldState.EMPTY).count();
        if (playerCount == 4L) {
            score += this.scoreWin;
        } else if (playerCount == 3L && emptyCount == 1L) {
            Objects.requireNonNull(this);
            score += 100;
        } else if (playerCount == 2L && emptyCount == 2L) {
            score += this.score2Row;
        }
        if (opponentCount == 4L) {
            score -= this.scoreLose;
        } else if (opponentCount == 3L && emptyCount == 1L) {
            Objects.requireNonNull(this);
            score -= 100;
        }
        return score;
    }

    private int evaluateDirection(VierConnectsBoard board, VierConnectsFieldState playerState, boolean isColumn) {
        int score = 0;
        int primarySize = isColumn ? board.getColumnSize() : board.getRowSize();
        int secondarySize = isColumn ? board.getRowSize() : board.getColumnSize();
        for (int primary = 0; primary < primarySize; ++primary) {
            int secondary;
            VierConnectsFieldState[] array = new VierConnectsFieldState[secondarySize];
            for (secondary = 0; secondary < secondarySize; ++secondary) {
                VierConnectsPosition position = isColumn ? VierConnectsPosition.of((int)secondary, (int)primary) : VierConnectsPosition.of((int)primary, (int)secondary);
                array[secondary] = board.getFieldAt(position).getState();
            }
            for (secondary = 0; secondary < secondarySize - 3; ++secondary) {
                VierConnectsFieldState[] window = Arrays.copyOfRange(array, secondary, secondary + 4);
                score += this.evaluateWindow(window, playerState);
            }
        }
        return score;
    }

    private int evaluateDiagonals(VierConnectsBoard board, VierConnectsFieldState playerState, boolean isPositiveSlope) {
        int score = 0;
        int rowSize = board.getRowSize();
        int columnSize = board.getColumnSize();
        for (int r = 0; r < rowSize - 3; ++r) {
            for (int c = 0; c < columnSize - 3; ++c) {
                VierConnectsFieldState[] window = new VierConnectsFieldState[4];
                for (int i = 0; i < 4; ++i) {
                    window[i] = isPositiveSlope ? board.getFieldAt(VierConnectsPosition.of((int)(r + i), (int)(c + i))).getState() : board.getFieldAt(VierConnectsPosition.of((int)(r + 3 - i), (int)(c + i))).getState();
                }
                score += this.evaluateWindow(window, playerState);
            }
        }
        return score;
    }

    public int evaluate(VierConnectsState state, VierConnectsPlayer player, int depth) {
        int score = 0;
        VierConnectsBoard board = state.getBoard();
        int columnSize = board.getColumnSize();
        int rowSize = board.getRowSize();
        VierConnectsFieldState playerState = player.isUsingCrosses() ? VierConnectsFieldState.CROSS : VierConnectsFieldState.NOUGHT;
        int centerCount = 0;
        for (int r = 0; r < rowSize; ++r) {
            if (board.getFieldAt(VierConnectsPosition.of((int)r, (int)(columnSize / 2))).getState() != playerState) continue;
            ++centerCount;
        }
        score += centerCount * this.scoreCenterCountMultiplier;
        score += this.maxDepth - depth;
        score += this.evaluateDirection(board, playerState, true);
        score += this.evaluateDirection(board, playerState, false);
        score += this.evaluateDiagonals(board, playerState, true);
        return score += this.evaluateDiagonals(board, playerState, false);
    }

    public VierConnectsPlayer getOpponent(VierConnectsState state) {
        return state.getCurrentPlayer() == state.getCrossesPlayer() ? state.getNoughtsPlayer() : state.getCrossesPlayer();
    }

    public VierConnectsFieldState getOpponent(VierConnectsFieldState state) {
        return state.equals((Object)VierConnectsFieldState.CROSS) ? VierConnectsFieldState.NOUGHT : VierConnectsFieldState.CROSS;
    }

    public String toString() {
        return "Vier-Gewinnt Minimax Strategy";
    }
}

