/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.GefangenenDilemma.strategy.stratsWithBrain;

import de.fhdw.gaming.GefangenenDilemma.domain.GDPlayer;
import de.fhdw.gaming.GefangenenDilemma.domain.GDState;
import de.fhdw.gaming.GefangenenDilemma.domain.GDStrategy;
import de.fhdw.gaming.GefangenenDilemma.moves.GDMove;
import de.fhdw.gaming.GefangenenDilemma.moves.factory.GDMoveFactory;
import de.fhdw.gaming.GefangenenDilemma.moves.impl.GDRemainSilentMove;
import de.fhdw.gaming.GefangenenDilemma.moves.impl.GDSnitchMove;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.Strategy;
import de.fhdw.gaming.memory.Key;
import de.fhdw.gaming.memory.impl.MemoryBrainImpl;
import de.fhdw.gaming.memory.impl.MemoryKeyImpl;
import de.fhdw.gaming.memory.impl.MemorySaveEntryImpl;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class GDPavlovStrategy
implements GDStrategy {
    private final GDMoveFactory moveFactory;

    GDPavlovStrategy(GDMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public Optional<GDMove> computeNextMove(int gameId, GDPlayer player, GDState state, long maxComputationTimePerMove) throws GameException, InterruptedException {
        GDPlayer opponent = null;
        for (Map.Entry entry : state.getPlayers().entrySet()) {
            if (((GDPlayer)entry.getValue()).equals(player)) continue;
            opponent = (GDPlayer)entry.getValue();
        }
        MemoryKeyImpl key = new MemoryKeyImpl((Player)player, opponent, (Strategy)this);
        List check = null;
        if (MemoryBrainImpl.getInstance().getMemory((Key)key) != null) {
            check = MemoryBrainImpl.getInstance().getMemory((Key)key).show();
        }
        if (check == null || check.isEmpty()) {
            return Optional.of(this.moveFactory.createRemainSilentMove());
        }
        int size = check.size();
        Move lastMoveUsedOpponent = ((MemorySaveEntryImpl)check.get(size - 1)).getOpponentMove();
        Move lastMoveUsedSelf = ((MemorySaveEntryImpl)check.get(size - 1)).getMyMove();
        return this.determineResponse(lastMoveUsedOpponent, lastMoveUsedSelf);
    }

    private Optional<GDMove> determineResponse(Move<?, ?> lastMoveUsedOpponent, Move<?, ?> lastMoveUsedSelf) {
        if (lastMoveUsedOpponent == null || lastMoveUsedSelf == null) {
            return Optional.of(this.moveFactory.createRemainSilentMove());
        }
        if (lastMoveUsedOpponent instanceof GDRemainSilentMove) {
            return Optional.of(this.repeatMove(lastMoveUsedSelf));
        }
        if (lastMoveUsedOpponent instanceof GDSnitchMove) {
            return Optional.of(this.changeMove(lastMoveUsedSelf));
        }
        return Optional.of(this.moveFactory.createRemainSilentMove());
    }

    private GDMove repeatMove(Move<?, ?> lastMove) {
        if (lastMove instanceof GDRemainSilentMove) {
            return this.moveFactory.createRemainSilentMove();
        }
        if (lastMove instanceof GDSnitchMove) {
            return this.moveFactory.createSnitchMove();
        }
        return this.moveFactory.createRemainSilentMove();
    }

    private GDMove changeMove(Move<?, ?> lastMove) {
        if (lastMove instanceof GDRemainSilentMove) {
            return this.moveFactory.createSnitchMove();
        }
        if (lastMove instanceof GDSnitchMove) {
            return this.moveFactory.createRemainSilentMove();
        }
        return this.moveFactory.createRemainSilentMove();
    }

    public String toString() {
        return GDPavlovStrategy.class.getSimpleName();
    }
}

