/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.othello.gui.impl;

import de.fhdw.gaming.othello.core.domain.OthelloPlayer;
import de.fhdw.gaming.othello.core.domain.OthelloState;
import de.fhdw.gaming.othello.core.domain.OthelloStrategy;
import de.fhdw.gaming.othello.core.moves.OthelloMove;
import de.fhdw.gaming.othello.core.moves.factory.OthelloMoveFactory;
import de.fhdw.gaming.othello.gui.OthelloBoardEventProvider;
import de.fhdw.gaming.othello.gui.event.OthelloBoardEventVisitor;
import de.fhdw.gaming.othello.gui.event.OthelloMakeMoveBoardEvent;
import de.fhdw.gaming.othello.gui.event.OthelloResignGameBoardEvent;
import de.fhdw.gaming.othello.gui.event.OthelloSkipMoveBoardEvent;
import de.fhdw.gaming.othello.gui.impl.OthelloGuiObserverImpl;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public final class OthelloInteractiveStrategy
implements OthelloStrategy {
    private final OthelloMoveFactory moveFactory;

    OthelloInteractiveStrategy(OthelloMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public Optional<OthelloMove> computeNextMove(int gameId, final OthelloPlayer player, OthelloState state) {
        Optional<OthelloBoardEventProvider> provider = OthelloGuiObserverImpl.getEventProvider(gameId);
        if (provider.isEmpty()) {
            return Optional.empty();
        }
        final AtomicReference move = new AtomicReference();
        provider.get().waitForEvent(player, state).accept(new OthelloBoardEventVisitor(){

            @Override
            public void handleMakeMove(OthelloMakeMoveBoardEvent event) {
                move.setPlain(OthelloInteractiveStrategy.this.moveFactory.createPlaceTokenMove(player.isUsingBlackTokens(), event.getFieldPosition()));
            }

            @Override
            public void handleSkipMove(OthelloSkipMoveBoardEvent event) {
                move.setPlain(OthelloInteractiveStrategy.this.moveFactory.createSkipMove(player.isUsingBlackTokens()));
            }

            @Override
            public void handleResignGame(OthelloResignGameBoardEvent event) {
            }
        });
        return Optional.ofNullable((OthelloMove)move.getPlain());
    }

    public String toString() {
        return OthelloInteractiveStrategy.class.getSimpleName();
    }

    public boolean isInteractive() {
        return true;
    }

    public void abortRequested(int gameId) {
        Optional<OthelloBoardEventProvider> provider = OthelloGuiObserverImpl.getEventProvider(gameId);
        provider.ifPresent(OthelloBoardEventProvider::cancelWaiting);
    }
}

