/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.othello.strategy.examples.random;

import de.fhdw.gaming.othello.core.domain.OthelloField;
import de.fhdw.gaming.othello.core.domain.OthelloFieldState;
import de.fhdw.gaming.othello.core.domain.OthelloPlayer;
import de.fhdw.gaming.othello.core.domain.OthelloState;
import de.fhdw.gaming.othello.core.domain.OthelloStrategy;
import de.fhdw.gaming.othello.core.moves.OthelloMove;
import de.fhdw.gaming.othello.core.moves.factory.OthelloMoveFactory;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;

public final class OthelloRandomMoveStrategy
implements OthelloStrategy {
    private static final Random RANDOM = new Random();
    private final OthelloMoveFactory moveFactory;

    OthelloRandomMoveStrategy(OthelloMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public Optional<OthelloMove> computeNextMove(int gameId, OthelloPlayer player, OthelloState state, long maxComputationTimePerMove) {
        OthelloField field2;
        boolean usingBlackTokens = player.isUsingBlackTokens();
        ArrayList<OthelloField> fields = new ArrayList<OthelloField>();
        for (OthelloField field2 : state.getBoard().getFieldsBeing(OthelloFieldState.EMPTY).values()) {
            if (!field2.isActive(usingBlackTokens)) continue;
            fields.add(field2);
        }
        if (fields.isEmpty()) {
            return Optional.of(this.moveFactory.createSkipMove(usingBlackTokens));
        }
        int index = RANDOM.nextInt(fields.size());
        field2 = (OthelloField)fields.get(index);
        return Optional.of(this.moveFactory.createPlaceTokenMove(usingBlackTokens, field2.getPosition()));
    }

    public String toString() {
        return OthelloRandomMoveStrategy.class.getSimpleName();
    }
}

