/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.othello.gui.impl;

import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.gui.GuiObserver;
import de.fhdw.gaming.othello.core.domain.OthelloPlayer;
import de.fhdw.gaming.othello.core.domain.OthelloState;
import de.fhdw.gaming.othello.core.domain.OthelloStrategy;
import de.fhdw.gaming.othello.core.moves.OthelloMove;
import de.fhdw.gaming.othello.gui.OthelloBoardEventProvider;
import de.fhdw.gaming.othello.gui.impl.OthelloBoardEventProviderImpl;
import de.fhdw.gaming.othello.gui.impl.OthelloBoardView;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.Node;

final class OthelloGuiObserverImpl
implements GuiObserver {
    private static final AtomicReference<WeakReference<OthelloGuiObserverImpl>> INSTANCE = new AtomicReference();
    private final Map<Integer, OthelloBoardView> boardViews;

    OthelloGuiObserverImpl() {
        INSTANCE.compareAndSet(null, new WeakReference<OthelloGuiObserverImpl>(this));
        this.boardViews = new LinkedHashMap<Integer, OthelloBoardView>();
    }

    static Optional<OthelloBoardEventProvider> getEventProvider(int gameId) {
        OthelloGuiObserverImpl instance = Optional.ofNullable(INSTANCE.get()).map(Reference::get).orElse(null);
        if (instance == null) {
            return Optional.empty();
        }
        OthelloBoardView boardView = instance.boardViews.get(gameId);
        return boardView == null ? Optional.empty() : Optional.of(new OthelloBoardEventProviderImpl(boardView));
    }

    public Optional<Node> gameCreated(Game<?, ?, ?, ?> game) {
        Optional<Game<OthelloPlayer, OthelloState, OthelloMove, OthelloStrategy>> othelloGame = OthelloGuiObserverImpl.toOthelloGame(game);
        if (othelloGame.isPresent()) {
            OthelloBoardView boardView = new OthelloBoardView(othelloGame.get());
            this.boardViews.put(game.getId(), boardView);
            return Optional.of(boardView.getNode());
        }
        return Optional.empty();
    }

    public void gamePaused(Game<?, ?, ?, ?> game) {
        OthelloBoardView boardView;
        Optional<Game<OthelloPlayer, OthelloState, OthelloMove, OthelloStrategy>> othelloGame = OthelloGuiObserverImpl.toOthelloGame(game);
        if (othelloGame.isPresent() && (boardView = this.boardViews.get(game.getId())) != null) {
            boardView.gamePaused(othelloGame.get());
        }
    }

    public void gameResumed(Game<?, ?, ?, ?> game) {
        OthelloBoardView boardView;
        Optional<Game<OthelloPlayer, OthelloState, OthelloMove, OthelloStrategy>> othelloGame = OthelloGuiObserverImpl.toOthelloGame(game);
        if (othelloGame.isPresent() && (boardView = this.boardViews.get(game.getId())) != null) {
            boardView.gameResumed(othelloGame.get());
        }
    }

    public void gameDestroyed(Game<?, ?, ?, ?> game) {
        OthelloBoardView boardView;
        Optional<Game<OthelloPlayer, OthelloState, OthelloMove, OthelloStrategy>> othelloGame = OthelloGuiObserverImpl.toOthelloGame(game);
        if (othelloGame.isPresent() && (boardView = this.boardViews.remove(game.getId())) != null) {
            boardView.destroy(othelloGame.orElseThrow());
        }
    }

    private static Optional<Game<OthelloPlayer, OthelloState, OthelloMove, OthelloStrategy>> toOthelloGame(Game<?, ?, ?, ?> game) {
        if (game.getState() instanceof OthelloState) {
            Game<?, ?, ?, ?> othelloGame = game;
            return Optional.of(othelloGame);
        }
        return Optional.empty();
    }
}

