/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.gui;

import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.gui.GuiObserver;
import de.fhdw.gaming.gui.util.FXUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;

final class GameRunner
implements Runnable {
    private final List<GuiObserver> observers;
    private final Optional<Game<?, ?, ?, ?>> game;
    private final GridPane gamePane;
    private final Thread thread;
    private final Semaphore gameSemaphore;
    private final Semaphore exitSemaphore;
    private final AtomicBoolean pauseRequested;
    private final AtomicBoolean abortRequested;
    private final ReadOnlyBooleanWrapper running;
    private final ReadOnlyBooleanWrapper finished;

    GameRunner(List<GuiObserver> observers, Game<?, ?, ?, ?> game, GridPane gamePane) {
        this.observers = observers;
        this.game = Optional.of(game);
        this.gamePane = gamePane;
        this.gameSemaphore = new Semaphore(0);
        this.exitSemaphore = new Semaphore(0);
        this.pauseRequested = new AtomicBoolean(true);
        this.abortRequested = new AtomicBoolean(false);
        this.running = new ReadOnlyBooleanWrapper(false);
        this.finished = new ReadOnlyBooleanWrapper(false);
        this.thread = new Thread(this);
    }

    ReadOnlyBooleanProperty runningProperty() {
        return this.running.getReadOnlyProperty();
    }

    ReadOnlyBooleanProperty finishedProperty() {
        return this.finished.getReadOnlyProperty();
    }

    void startGame() {
        this.thread.start();
    }

    void continueGame() {
        this.game.orElseThrow(() -> new IllegalStateException("GameRunner already closed, reuse impossible!"));
        this.pauseRequested.set(false);
        this.running.set(true);
        this.gameSemaphore.release();
    }

    void pauseGame() {
        this.game.orElseThrow(() -> new IllegalStateException("GameRunner already closed, reuse impossible!"));
        this.pauseRequested.set(true);
        this.running.set(false);
    }

    void abortGame() {
        this.game.orElseThrow(() -> new IllegalStateException("GameRunner already closed, reuse impossible!"));
        this.abortRequested.set(true);
        this.game.get().abortRequested();
        this.pauseRequested.set(false);
        this.gameSemaphore.release();
    }

    void terminate() {
        this.exitSemaphore.release();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        try {
            try {
                ArrayList nodes = new ArrayList();
                this.observers.forEach(o -> {
                    Optional<Node> node = o.gameCreated(this.game.orElseThrow());
                    node.ifPresent(nodes::add);
                });
                this.game.orElseThrow().start();
                Platform.runLater(() -> this.layoutNodes(nodes));
                while (!this.game.orElseThrow().isFinished()) {
                    this.pauseIfRequested();
                    if (this.abortRequested.get()) {
                        break;
                    }
                    this.game.orElseThrow().makeMove();
                }
            }
            finally {
                this.cleanupGame();
            }
        }
        catch (InterruptedException nodes) {
        }
        catch (Exception e) {
            Platform.runLater(() -> {
                FXUtil.showAlert(this.gamePane.getScene().getWindow(), Alert.AlertType.ERROR, e.getMessage());
                this.finished.set(true);
            });
        }
        finally {
            this.game.orElseThrow().close();
        }
    }

    private void pauseIfRequested() throws InterruptedException {
        while (this.pauseRequested.get()) {
            this.observers.forEach(o -> o.gamePaused(this.game.orElseThrow()));
            this.gameSemaphore.acquire();
            this.observers.forEach(o -> o.gameResumed(this.game.orElseThrow()));
        }
    }

    private void cleanupGame() throws InterruptedException {
        Platform.runLater(() -> {
            this.running.set(false);
            this.finished.set(true);
        });
        this.exitSemaphore.acquire();
        this.observers.forEach(o -> o.gameDestroyed(this.game.orElseThrow()));
    }

    private void layoutNodes(List<Node> nodes) {
        int numColumns = (int)Math.ceil(Math.sqrt(nodes.size()));
        int currentRow = 0;
        int currentColumn = 0;
        for (Node node : nodes) {
            this.gamePane.add(node, currentColumn, currentRow);
            GridPane.setHgrow((Node)node, (Priority)Priority.ALWAYS);
            GridPane.setVgrow((Node)node, (Priority)Priority.ALWAYS);
            if (currentRow * numColumns + currentColumn + 1 == nodes.size()) {
                GridPane.setColumnSpan((Node)node, (Integer)(numColumns - currentColumn));
            }
            if ((currentColumn = (currentColumn + 1) % numColumns) != 0) continue;
            ++currentRow;
        }
    }
}

