/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.gui;

import de.fhdw.gaming.core.ui.InputProvider;
import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.BooleanFieldType;
import de.fhdw.gaming.core.ui.type.FieldType;
import de.fhdw.gaming.core.ui.type.FieldTypeException;
import de.fhdw.gaming.core.ui.type.FieldTypeVisitor;
import de.fhdw.gaming.core.ui.type.IntegerFieldType;
import de.fhdw.gaming.core.ui.type.ObjectFieldType;
import de.fhdw.gaming.core.ui.type.StringFieldType;
import de.fhdw.gaming.core.ui.type.validator.Validator;
import de.fhdw.gaming.gui.ControlCreator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableObjectValue;
import javafx.event.ActionEvent;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Window;
import javafx.util.Duration;

final class InteractiveDialogInputProvider
implements InputProvider {
    private final Window owner;
    private final Map<String, NeededDataEntry> neededData;
    private final Map<String, Object> providedData;

    InteractiveDialogInputProvider(Window owner) {
        this.owner = owner;
        this.neededData = new LinkedHashMap<String, NeededDataEntry>();
        this.providedData = new LinkedHashMap<String, Object>();
    }

    @SafeVarargs
    public final InteractiveDialogInputProvider needString(String id, String prompt, Optional<String> defaultValue, Validator<String> ... validators) {
        this.neededData.put(id, new NeededDataEntry(prompt, new StringFieldType(defaultValue).validateBy(validators)));
        return this;
    }

    public InteractiveDialogInputProvider fixedString(String id, String fixedValue) {
        this.providedData.put(id, fixedValue);
        return this;
    }

    @SafeVarargs
    public final InteractiveDialogInputProvider needInteger(String id, String prompt, Optional<Integer> defaultValue, Validator<Integer> ... validators) {
        this.neededData.put(id, new NeededDataEntry(prompt, new IntegerFieldType(defaultValue).validateBy(validators)));
        return this;
    }

    public InteractiveDialogInputProvider fixedInteger(String id, Integer fixedValue) {
        this.providedData.put(id, fixedValue);
        return this;
    }

    @SafeVarargs
    public final InteractiveDialogInputProvider needBoolean(String id, String prompt, Optional<Boolean> defaultValue, Validator<Boolean> ... validators) {
        this.neededData.put(id, new NeededDataEntry(prompt, new BooleanFieldType(defaultValue).validateBy(validators)));
        return this;
    }

    public InteractiveDialogInputProvider fixedBoolean(String id, Boolean fixedValue) {
        this.providedData.put(id, fixedValue);
        return this;
    }

    public InteractiveDialogInputProvider needObject(String id, String prompt, Optional<Object> defaultValue, Set<?> objectSet) {
        this.neededData.put(id, new NeededDataEntry(prompt, (FieldType<?>)new ObjectFieldType(defaultValue, objectSet)));
        return this;
    }

    public InteractiveDialogInputProvider fixedObject(String id, Object fixedValue) {
        this.providedData.put(id, fixedValue);
        return this;
    }

    public Map<String, Object> requestData(String title) throws InputProviderException {
        Dialog dialog = new Dialog();
        dialog.initOwner(this.owner);
        dialog.setTitle(title);
        dialog.setResizable(true);
        dialog.getDialogPane().getButtonTypes().add((Object)ButtonType.OK);
        dialog.getDialogPane().getButtonTypes().add((Object)ButtonType.CANCEL);
        GridPane gridPane = new GridPane();
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        ColumnConstraints column1 = new ColumnConstraints();
        column1.setHalignment(HPos.RIGHT);
        column1.setHgrow(Priority.NEVER);
        gridPane.getColumnConstraints().add((Object)column1);
        ColumnConstraints column2 = new ColumnConstraints();
        column2.setHalignment(HPos.LEFT);
        column2.setHgrow(Priority.ALWAYS);
        column2.setMaxWidth(Double.MAX_VALUE);
        gridPane.getColumnConstraints().add((Object)column2);
        dialog.getDialogPane().setContent((Node)gridPane);
        LinkedHashMap<String, WritableObjectValue<Object>> values = new LinkedHashMap<String, WritableObjectValue<Object>>();
        LinkedHashMap<String, Region> controls = new LinkedHashMap<String, Region>();
        for (Map.Entry<String, NeededDataEntry> entry : this.neededData.entrySet()) {
            Region control = this.addFieldControl(entry.getKey(), entry.getValue(), values, gridPane, controls.isEmpty());
            controls.put(entry.getKey(), control);
        }
        dialog.getDialogPane().lookupButton(ButtonType.OK).addEventFilter(ActionEvent.ACTION, event -> {
            for (Map.Entry entry : values.entrySet()) {
                Region control = (Region)controls.get(entry.getKey());
                if (((WritableObjectValue)entry.getValue()).get() != null) continue;
                this.validationFailed(control);
                event.consume();
            }
        });
        Optional dialogResult = dialog.showAndWait();
        if (dialogResult.orElse(ButtonType.CANCEL).equals(ButtonType.OK)) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            for (Map.Entry entry : values.entrySet()) {
                result.put((String)entry.getKey(), ((WritableObjectValue)entry.getValue()).get());
            }
            return result;
        }
        throw new InputProviderException("Dialog aborted.");
    }

    private Region addFieldControl(String id, NeededDataEntry neededDataEntry, Map<String, WritableObjectValue<Object>> values, GridPane gridPane, boolean requestFocus) throws InputProviderException {
        values.put(id, (WritableObjectValue<Object>)new SimpleObjectProperty(neededDataEntry.getFieldType().getDefaultValue().orElse(null)));
        Label prompt = new Label(neededDataEntry.getPrompt());
        Label errorLabel = new Label();
        errorLabel.setTextFill((Paint)Color.RED);
        Consumer<String> validationHandler = message -> {
            errorLabel.setText(message);
            if (message.isEmpty()) {
                prompt.setTextFill((Paint)Color.BLACK);
            } else {
                prompt.setTextFill((Paint)Color.RED);
            }
        };
        Optional<Object> provided = Optional.ofNullable(this.providedData.get(id));
        ControlCreator controlCreator = new ControlCreator(id, validationHandler, provided, values);
        try {
            neededDataEntry.getFieldType().accept((FieldTypeVisitor)controlCreator);
            gridPane.addRow(gridPane.getRowCount(), new Node[]{prompt, controlCreator.getResult()});
            gridPane.addRow(gridPane.getRowCount(), new Node[]{errorLabel});
            GridPane.setColumnSpan((Node)errorLabel, (Integer)2);
            GridPane.setHalignment((Node)errorLabel, (HPos)HPos.LEFT);
            GridPane.setHgrow((Node)errorLabel, (Priority)Priority.ALWAYS);
        }
        catch (FieldTypeException e) {
            throw new InputProviderException(String.format("Error while creating control for field %s: %s", id, e.getMessage()), (Throwable)e);
        }
        if (requestFocus) {
            Platform.runLater(() -> controlCreator.getFocusTarget().requestFocus());
        }
        return controlCreator.getResult();
    }

    private void validationFailed(Region control) {
        Background oldBackground = control.getBackground();
        Background redBackground = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.RED, CornerRadii.EMPTY, Insets.EMPTY)});
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.4), evt -> control.setBackground(redBackground), new KeyValue[0]), new KeyFrame(Duration.seconds((double)0.8), evt -> control.setBackground(oldBackground), new KeyValue[0])});
        timeline.setCycleCount(2);
        timeline.play();
    }

    public InputProvider getNext(Map<String, Object> lastDataSet) {
        return new InteractiveDialogInputProvider(this.owner);
    }

    private static final class NeededDataEntry {
        private final String prompt;
        private final FieldType<?> fieldType;

        NeededDataEntry(String prompt, FieldType<?> fieldType) {
            this.prompt = prompt + ":";
            this.fieldType = fieldType;
        }

        String getPrompt() {
            return this.prompt;
        }

        FieldType<?> getFieldType() {
            return this.fieldType;
        }
    }
}

