/*
 * Copyright © 2020-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of gaming-gui.
 *
 * Gaming-gui is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Gaming-gui is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * gaming-gui. If not, see <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

/**
 * Allows to create an {@link GuiObserver}.
 */
public interface GuiObserverFactory {

    /**
     * Creates a {@link GuiObserver} object.
     */
    GuiObserver createObserver();

    /**
     * Returns all available observer factories.
     */
    static List<GuiObserverFactory> getInstances() {
        final ServiceLoader<GuiObserverFactory> services = ServiceLoader.load(GuiObserverFactory.class);
        final List<GuiObserverFactory> list = new ArrayList<>();
        services.iterator().forEachRemaining(list::add);
        return list;
    }
}
