/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.contest.util;

import de.fhdw.gaming.contest.util.CombinationSplitIterator;
import de.fhdw.gaming.contest.util.PermutationSplitIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class CombinatoricsHelper {
    private CombinatoricsHelper() {
    }

    public static long factorial(int num) {
        return CombinatoricsHelper.nthProduct(1, num);
    }

    public static long nthProduct(int start, int end) {
        return LongStream.rangeClosed(start + 1, end).reduce(1L, (x, y) -> x * y);
    }

    public static long nOverK(int nValue, int kValue) {
        if (nValue < kValue) {
            return 0L;
        }
        if (kValue < nValue - kValue) {
            return CombinatoricsHelper.nthProduct(nValue - kValue, nValue) / CombinatoricsHelper.factorial(kValue);
        }
        return CombinatoricsHelper.nthProduct(kValue, nValue) / CombinatoricsHelper.factorial(nValue - kValue);
    }

    public static <T> Stream<List<T>> permutations(List<T> items) {
        return LongStream.range(0L, CombinatoricsHelper.factorial(items.size())).mapToObj(permutationNumber -> CombinatoricsHelper.permutation(permutationNumber, new LinkedList(items)));
    }

    public static <T> Stream<List<T>> permutationsWithRepetition(List<T> items, Comparator<T> comparator) {
        return StreamSupport.stream(new PermutationSplitIterator<T>(items, comparator), false);
    }

    public static <T extends Comparable<T>> Stream<List<T>> permutationsWithRepetition(List<T> items) {
        return StreamSupport.stream(PermutationSplitIterator.create(items), false);
    }

    public static <T> Stream<List<T>> combinations(List<T> items, int sublistSize) {
        return StreamSupport.stream(new CombinationSplitIterator<T>(items, sublistSize, false), false);
    }

    public static <T> Stream<List<T>> combinationsWithRepetition(List<T> items, int sublistSize) {
        return StreamSupport.stream(new CombinationSplitIterator<T>(items, sublistSize, true), false);
    }

    private static <T> List<T> permutation(long permutationNumber, List<T> input) {
        long count = permutationNumber;
        long factorial = CombinatoricsHelper.factorial(input.size());
        ArrayList<T> output = new ArrayList<T>();
        while (!input.isEmpty()) {
            long index = count / (factorial /= (long)input.size());
            assert ((long)((int)index) == index);
            output.add(input.remove((int)index));
            count %= factorial;
        }
        return output;
    }
}

