/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.gui.util;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Optional;
import javafx.beans.value.ObservableBooleanValue;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public final class FXUtil {
    private static final double ICON_RATIO = 0.75;
    private static final double MIN_BUTTON_WIDTH = 50.0;
    private static final double MIN_BUTTON_HEIGHT = 50.0;

    private FXUtil() {
    }

    public static Optional<ButtonType> showAlert(Window owner, Alert.AlertType type, String contents) {
        Alert alert = new Alert(type, contents, new ButtonType[0]);
        alert.initOwner(owner);
        alert.setResizable(true);
        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        return alert.showAndWait();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static Optional<Image> fromSVGImage(InputStream in, double width, double height) {
        try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(in);){
            Iterator<ImageReader> itReader = ImageIO.getImageReaders(imageInputStream);
            if (!itReader.hasNext()) {
                Optional<Image> optional = Optional.empty();
                return optional;
            }
            ImageReader reader = itReader.next();
            ImageReadParam param = reader.getDefaultReadParam();
            if (param.canSetSourceRenderSize()) {
                param.setSourceRenderSize(new Dimension((int)width, (int)height));
            }
            reader.setInput(imageInputStream, true, true);
            try {
                BufferedImage bufferedImage = reader.read(0, param);
                Optional<WritableImage> optional = Optional.of(SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null));
                reader.dispose();
                return optional;
            }
            catch (Throwable throwable) {
                reader.dispose();
                throw throwable;
            }
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public static Button createButtonWithSVGImage(ButtonDescriptor buttonDescriptor) {
        Button button = new Button();
        button.setContentDisplay(ContentDisplay.TOP);
        button.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        button.setMinSize(50.0, 50.0);
        FXUtil.setButtonProperties(button, buttonDescriptor, 1.0, 1.0);
        button.widthProperty().addListener((value, oldValue, newValue) -> FXUtil.loadAndSetButtonIcon(button, buttonDescriptor.getIconName(), newValue.doubleValue() * 0.75, button.getHeight() * 0.75));
        button.heightProperty().addListener((value, oldValue, newValue) -> FXUtil.loadAndSetButtonIcon(button, buttonDescriptor.getIconName(), button.getWidth() * 0.75, newValue.doubleValue() * 0.75));
        return button;
    }

    public static Button createTwoModeButtonWithSVGImage(ObservableBooleanValue mode, ButtonDescriptor buttonDescriptorModeFalse, ButtonDescriptor buttonDescriptorModeTrue) {
        Button button = new Button();
        button.setContentDisplay(ContentDisplay.TOP);
        button.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        button.setMinSize(50.0, 50.0);
        FXUtil.setButtonProperties(button, mode.get() ? buttonDescriptorModeTrue : buttonDescriptorModeFalse, 1.0, 1.0);
        mode.addListener((value, oldValue, newValue) -> FXUtil.setButtonProperties(button, newValue != false ? buttonDescriptorModeTrue : buttonDescriptorModeFalse, button.getWidth() * 0.75, button.getHeight() * 0.75));
        button.widthProperty().addListener((value, oldValue, newValue) -> FXUtil.setButtonProperties(button, mode.get() ? buttonDescriptorModeTrue : buttonDescriptorModeFalse, newValue.doubleValue() * 0.75, button.getHeight() * 0.75));
        button.heightProperty().addListener((value, oldValue, newValue) -> FXUtil.setButtonProperties(button, mode.get() ? buttonDescriptorModeTrue : buttonDescriptorModeFalse, button.getWidth() * 0.75, newValue.doubleValue() * 0.75));
        return button;
    }

    private static void setButtonProperties(Button button, ButtonDescriptor buttonDescriptor, double width, double height) {
        button.setText(buttonDescriptor.getButtonText());
        button.setTooltip(new Tooltip(buttonDescriptor.getButtonDescription()));
        FXUtil.loadAndSetButtonIcon(button, buttonDescriptor.getIconName(), width, height);
    }

    private static void loadAndSetButtonIcon(Button button, String iconName, double width, double height) {
        String path = String.format("/icons/%s.svg", iconName);
        try (InputStream in = FXUtil.class.getResourceAsStream(path);){
            Optional<Image> buttonImage = FXUtil.fromSVGImage(in, Math.max(1.0, width), Math.max(1.0, height));
            buttonImage.ifPresent(image -> button.setGraphic((Node)new ImageView(image)));
        }
        catch (IOException e) {
            button.setGraphic(null);
        }
    }

    public static final class ButtonDescriptor {
        private String buttonText;
        private String buttonDescription;
        private String iconName;

        public String getButtonText() {
            return this.buttonText;
        }

        public String getButtonDescription() {
            return this.buttonDescription;
        }

        public String getIconName() {
            return this.iconName;
        }

        public ButtonDescriptor text(String newButtonText) {
            this.buttonText = newButtonText;
            return this;
        }

        public ButtonDescriptor description(String newButtonDescription) {
            this.buttonDescription = newButtonDescription;
            return this;
        }

        public ButtonDescriptor icon(String newIconName) {
            this.iconName = newIconName;
            return this;
        }
    }
}

