package de.fhdw.gaming.ipspiel21.dilemmaCustomized.impl;

import de.fhdw.gaming.core.domain.GameBuilder;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaGame;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaGameBuilder;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaPlayerBuilder;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaStrategy;
import de.fhdw.gaming.ipspiel21.evolution.MemoryObserver;

/**
 * Wraps a {@link DilemmaGameBuilder} and adds a {@link MemoryObserver} to the game created.
 */
final class DilemmaCustomizedGameBuilderWrapper implements DilemmaGameBuilder {

    /**
     * The wrapped {@link DilemmaGameBuilder}.
     */
    private final DilemmaGameBuilder wrapped;

    /**
     * Constructor.
     *
     * @param wrapped The wrapped {@link DilemmaGameBuilder}.
     */
    DilemmaCustomizedGameBuilderWrapper(final DilemmaGameBuilder wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public GameBuilder changeMaximumComputationTimePerMove(final int newMaxComputationTimePerMove) {
        this.wrapped.changeMaximumComputationTimePerMove(newMaxComputationTimePerMove);
        return this;
    }

    @Override
    public DilemmaPlayerBuilder createPlayerBuilder() {
        return this.wrapped.createPlayerBuilder();
    }

    @Override
    public DilemmaGameBuilder addPlayerBuilder(final DilemmaPlayerBuilder playerBuilder, final DilemmaStrategy strategy)
            throws GameException {
        this.wrapped.addPlayerBuilder(playerBuilder, strategy);
        return this;
    }

    @Override
    public DilemmaGameBuilder changeObserverFactoryProvider(final ObserverFactoryProvider newObserverFactoryProvider) {
        this.wrapped.changeObserverFactoryProvider(newObserverFactoryProvider);
        return this;
    }

    @Override
    public DilemmaGame build(final int id) throws GameException, InterruptedException {
        final DilemmaGame game = this.wrapped.build(id);
        game.addObserver(MemoryObserver.INSTANCE);
        return game;
    }
}
