/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.dilemmaOriginal.strategy;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaPlayer;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaState;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaStrategy;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.DilemmaMove;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.factory.DilemmaMoveFactory;
import de.fhdw.gaming.ipspiel21.evolution.GameHistory;
import java.util.List;
import java.util.Optional;

final class DilemmaPunisherStrategy
implements DilemmaStrategy {
    private final DilemmaMoveFactory moveFactory;

    public DilemmaPunisherStrategy(DilemmaMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public Optional<DilemmaMove> computeNextMove(int gameId, DilemmaPlayer player, DilemmaState state) throws GameException, InterruptedException {
        if (player.getGameHistoryCollection().numberOfPlayedGames() == 0) {
            return Optional.of(this.moveFactory.createYesMove());
        }
        if (player.getGameHistoryCollection().getSpecificGameHistory(Integer.valueOf(0)).getOpponentMove(Integer.valueOf(0)).equals(this.moveFactory.createNoMove()) || this.getOutcomeDifference(player.getGameHistoryCollection().getGameHistories()) < 0.0) {
            return Optional.of(this.moveFactory.createNoMove());
        }
        return Optional.of(this.moveFactory.createYesMove());
    }

    private double getOutcomeDifference(List<GameHistory> games) {
        Double playerOutcome = 0.0;
        Double enemyPlayerOutcome = 0.0;
        for (GameHistory game : games) {
            playerOutcome = playerOutcome + (Double)game.getOutcome().get();
            enemyPlayerOutcome = enemyPlayerOutcome + (Double)game.getOpponentOutcome().get();
        }
        return playerOutcome - enemyPlayerOutcome;
    }

    public String toString() {
        return DilemmaPunisherStrategy.class.getSimpleName();
    }
}

