package de.fhdw.gaming.ipspiel21.evolution;

import java.util.List;
import java.util.stream.Collectors;

/**
 * Implements @GameHistoryCollection.
 **/
public class GameHistoryCollectionImpl implements GameHistoryCollection {

    /**
     * Collection of game histories.
     **/
    private final List<GameHistory> gameHistoryCollection;

    /**
     * Creates a GameHistoryCollection.
     *
     * @param gameHistoryCollection The collection of Game histories
     **/
    public GameHistoryCollectionImpl(final List<GameHistory> gameHistoryCollection) {
        super();
        this.gameHistoryCollection = gameHistoryCollection;
    }

    @Override
    public Integer numberOfPlayedGames() {
        final List<GameHistory> histories = this.gameHistoryCollection.stream().filter(p -> p.getOutcome().isPresent())
                .collect(Collectors.toList());
        return histories.size();
    }

    @Override
    public List<GameHistory> getGameHistories() {
        return this.gameHistoryCollection;
    }

    @Override
    public GameHistory getSpecificGameHistory(final Integer index) {
        if (this.gameHistoryCollection.get(index).getOutcome().isPresent()) {
            return this.gameHistoryCollection.get(index);
        } else {
            return this.gameHistoryCollection.get(index + 1);
        }
    }

    @Override
    public void addGameHistory(final GameHistory history) {
        this.gameHistoryCollection.add(0, history);
    }

}
