/**
 *
 */
package de.fhdw.gaming.ipspiel21.evolution;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

import de.fhdw.gaming.core.domain.Move;

/**
 * Implements @GameHistory.
 */
public class GameHistoryImpl implements GameHistory {

    /**
     * Collection of moves made by the player who owns this game history.
     **/
    private final List<Move<?, ?>> myMoves;

    /**
     * Collection of moves made by the players opponent.
     **/
    private final List<Move<?, ?>> opponentMoves;

    /**
     * The game id for which the history is.
     **/
    private final Integer gameId;

    /**
     * The player outcome.
     **/
    private Optional<Double> myOutcome;

    /**
     * The players opponent outcome.
     **/
    private Optional<Double> opponentOutcome;

    /**
     * Creates a GameHistory.
     *
     * @param gameId The game id
     **/
    public GameHistoryImpl(final Integer gameId) {
        super();
        this.myMoves = new ArrayList<>();
        this.opponentMoves = new ArrayList<>();
        this.gameId = gameId;
        this.myOutcome = Optional.empty();
        this.opponentOutcome = Optional.empty();
    }

    @Override
    public Move<?, ?> getMove(final Integer index) {
        return this.myMoves.get(index);
    }

    @Override
    public Move<?, ?> getOpponentMove(final Integer index) {
        return this.opponentMoves.get(index);
    }

    @Override
    public Optional<Double> getOutcome() {
        return this.myOutcome;
    }

    @Override
    public void setOutcome(final boolean opponent, final Optional<Double> outcome) {
        if (opponent) {
            this.opponentOutcome = outcome;
        } else {
            this.myOutcome = outcome;
        }
    }

    @Override
    public Optional<Double> getOpponentOutcome() {
        return this.opponentOutcome;
    }

    @Override
    public Integer numberOfPlayedMoves() {
        return this.myMoves.size();
    }

    @Override
    public Integer getGameId() {
        return this.gameId;
    }

    @Override
    public void addMove(final boolean opponent, final Move<?, ?> move) {
        if (opponent) {
            this.opponentMoves.add(0, move);
        } else {
            this.myMoves.add(0, move);
        }
    }

}
