package de.fhdw.gaming.ipspiel21.freizeit.strategy;

import java.util.Optional;
import java.util.Random;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel21.freizeit.domain.FreizeitPlayer;
import de.fhdw.gaming.ipspiel21.freizeit.domain.FreizeitState;
import de.fhdw.gaming.ipspiel21.freizeit.domain.FreizeitStrategy;
import de.fhdw.gaming.ipspiel21.freizeit.moves.FreizeitMove;
import de.fhdw.gaming.ipspiel21.freizeit.moves.factory.FreizeitMoveFactory;

/**
 * Implements a balanced {@link FreizeitStrategy} for the player that favors soccer.
 *
 * @author Leonard Frank
 */
public class FreizeitBalancedSoccerFavoriteStrategy implements FreizeitStrategy {

    /**
     * Factory for creating FreizeitMoves.
     */
    private final FreizeitMoveFactory moveFactory;

    /**
     * Random generator to determine next move.
     */
    private final Random rand;

    /**
     * Creates a {@link FreizeitBalancedSoccerFavoriteStrategy}.
     *
     * @param moveFactory Factory for creating FreizeitMoves
     */
    public FreizeitBalancedSoccerFavoriteStrategy(final FreizeitMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
        this.rand = new Random();
    }

    @Override
    public Optional<FreizeitMove> computeNextMove(final int gameId, final FreizeitPlayer player,
            final FreizeitState state) throws GameException, InterruptedException {

        if (this.rand.nextInt(3) == 0) {
            return Optional.of(this.moveFactory.createCinemaMove());
        } else {
            return Optional.of(this.moveFactory.createSoccerMove());
        }
    }

    @Override
    public String toString() {
        return FreizeitBalancedSoccerFavoriteStrategy.class.getSimpleName();
    }

}
