/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.viergewinnt.gui.impl;

import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntBoard;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntField;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntPlayer;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntPosition;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntState;
import de.fhdw.gaming.ipspiel21.viergewinnt.gui.VierGewinntBoardEventProvider;
import de.fhdw.gaming.ipspiel21.viergewinnt.gui.event.VierGewinntBoardEvent;
import de.fhdw.gaming.ipspiel21.viergewinnt.gui.event.VierGewinntMakeMoveBoardEvent;
import de.fhdw.gaming.ipspiel21.viergewinnt.gui.impl.VierGewinntBoardView;
import de.fhdw.gaming.ipspiel21.viergewinnt.gui.impl.VierGewinntFieldView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.scene.Cursor;
import javafx.scene.input.MouseButton;

final class VierGewinntBoardEventProviderImpl
implements VierGewinntBoardEventProvider {
    private final VierGewinntBoardView boardView;

    VierGewinntBoardEventProviderImpl(VierGewinntBoardView boardView) {
        this.boardView = boardView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VierGewinntBoardEvent waitForEvent(VierGewinntPlayer player, VierGewinntState state) {
        Runnable cleanUp;
        Object fieldViews;
        LinkedHashMap<VierGewinntPosition, VierGewinntFieldView> possibleFieldViews = new LinkedHashMap<VierGewinntPosition, VierGewinntFieldView>();
        for (VierGewinntField entry : state.getBoard().getAllPlayableFields()) {
            possibleFieldViews.put(entry.getPosition(), this.boardView.getFieldView(entry.getPosition()).orElseThrow());
        }
        AtomicReference<VierGewinntBoardEvent> event = new AtomicReference<VierGewinntBoardEvent>();
        if (possibleFieldViews.isEmpty()) {
            fieldViews = this.setupInactiveFields(state.getBoard());
            cleanUp = () -> this.cleanUpFields((Collection<? extends VierGewinntFieldView>)fieldViews);
        } else {
            this.setupActiveFields(possibleFieldViews, event);
            cleanUp = () -> this.cleanUpFields(possibleFieldViews.values());
        }
        try {
            this.boardView.getUserInputSemaphore().acquire();
            fieldViews = event.get();
            return fieldViews;
        }
        catch (InterruptedException e) {
            VierGewinntBoardEvent vierGewinntBoardEvent = null;
            return vierGewinntBoardEvent;
        }
        finally {
            Platform.runLater((Runnable)cleanUp);
        }
    }

    private void setupActiveFields(Map<VierGewinntPosition, VierGewinntFieldView> emptyFieldViews, AtomicReference<VierGewinntBoardEvent> event) {
        for (Map.Entry<VierGewinntPosition, VierGewinntFieldView> entry : emptyFieldViews.entrySet()) {
            VierGewinntPosition position = entry.getKey();
            VierGewinntFieldView fieldView = entry.getValue();
            Platform.runLater(() -> {
                fieldView.setCursor(Cursor.CROSSHAIR);
                fieldView.setOnMouseClicked(mouseEvent -> {
                    if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                        event.set(new VierGewinntMakeMoveBoardEvent(position));
                        this.boardView.getUserInputSemaphore().release();
                    }
                });
            });
        }
    }

    private List<VierGewinntFieldView> setupInactiveFields(VierGewinntBoard board) {
        ArrayList fields = new ArrayList();
        board.getFields().forEach(field -> fields.add(field));
        ArrayList<VierGewinntFieldView> fieldViews = new ArrayList<VierGewinntFieldView>();
        for (VierGewinntField field2 : fields) {
            VierGewinntFieldView fieldView = this.boardView.getFieldView(field2.getPosition()).orElseThrow();
            fieldViews.add(fieldView);
            Platform.runLater(() -> {
                fieldView.setCursor(Cursor.CLOSED_HAND);
                fieldView.setOnMouseClicked(null);
            });
        }
        return fieldViews;
    }

    private void cleanUpFields(Collection<? extends VierGewinntFieldView> fieldViews) {
        for (VierGewinntFieldView vierGewinntFieldView : fieldViews) {
            vierGewinntFieldView.setCursor(Cursor.DEFAULT);
            vierGewinntFieldView.setOnMouseClicked(null);
        }
    }

    @Override
    public void cancelWaiting() {
        this.boardView.getUserInputSemaphore().release();
    }
}

