/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.demo.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel21.demo.domain.DemoPlayer;
import de.fhdw.gaming.ipspiel21.demo.domain.DemoPlayerBuilder;
import de.fhdw.gaming.ipspiel21.demo.domain.DemoState;
import de.fhdw.gaming.ipspiel21.demo.domain.impl.DemoPlayerImpl;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

final class DemoPlayerBuilderImpl
implements DemoPlayerBuilder {
    private Optional<String> name = Optional.empty();
    private Optional<Map<Boolean, Map<Boolean, Double>>> possibleOutcomes = Optional.empty();

    DemoPlayerBuilderImpl() {
    }

    @Override
    public DemoPlayerBuilderImpl changeName(String newName) {
        this.name = Optional.of(newName);
        return this;
    }

    @Override
    public DemoPlayerBuilder changePossibleOutcomes(Map<Boolean, Map<Boolean, Double>> newPossibleOutcomes) {
        this.possibleOutcomes = Optional.of(newPossibleOutcomes);
        return this;
    }

    @Override
    public DemoPlayer build(DemoState state) throws GameException {
        return new DemoPlayerImpl(state, this.name.orElseThrow(), this.checkPossibleOutcomes(this.possibleOutcomes.orElseThrow()));
    }

    private Map<Boolean, Map<Boolean, Double>> checkPossibleOutcomes(Map<Boolean, Map<Boolean, Double>> outcomes) {
        this.checkPossibleOutcome(outcomes, false, false);
        this.checkPossibleOutcome(outcomes, false, true);
        this.checkPossibleOutcome(outcomes, true, false);
        this.checkPossibleOutcome(outcomes, true, true);
        return outcomes;
    }

    private void checkPossibleOutcome(Map<Boolean, Map<Boolean, Double>> outcomes, boolean firstChoice, boolean secondChoice) {
        if (outcomes.getOrDefault(firstChoice, Collections.emptyMap()).get(secondChoice) == null) {
            throw new IllegalArgumentException(String.format("No outcome defined for player '%s' and combination %s/%s.", this.name, DemoPlayerBuilderImpl.toAnswer(firstChoice), DemoPlayerBuilderImpl.toAnswer(secondChoice)));
        }
    }

    private static String toAnswer(boolean value) {
        return value ? "yes" : "no";
    }
}

