/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.demo.domain.impl;

import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.ipspiel21.demo.domain.DemoPlayer;
import de.fhdw.gaming.ipspiel21.demo.domain.DemoState;
import de.fhdw.gaming.ipspiel21.evolution.EvolutionPlayerImpl;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class DemoPlayerImpl
extends EvolutionPlayerImpl
implements DemoPlayer {
    private final DemoState gameState;
    private final String name;
    private final Map<Boolean, Map<Boolean, Double>> possibleOutcomes;

    DemoPlayerImpl(DemoState gameState, String name, Map<Boolean, Map<Boolean, Double>> possibleOutcomes) {
        this.gameState = gameState;
        this.name = Objects.requireNonNull(name, "name");
        this.possibleOutcomes = Collections.unmodifiableMap(new LinkedHashMap<Boolean, Map<Boolean, Double>>(Objects.requireNonNull(possibleOutcomes, "possibleOutcomes")));
    }

    public String toString() {
        return String.format("DemoPlayer[name=%s, state=%s, outcome=%s]", this.name, this.getState(), this.getOutcome());
    }

    public boolean equals(Object obj) {
        if (obj instanceof DemoPlayerImpl) {
            DemoPlayerImpl other = (DemoPlayerImpl)obj;
            return this.name.equals(other.name) && this.getState().equals((Object)other.getState()) && this.getOutcome().equals(other.getOutcome());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Map<Boolean, Map<Boolean, Double>> getPossibleOutcomes() {
        return this.possibleOutcomes;
    }

    public PlayerState getState() {
        return this.gameState.getPlayerState(this.name);
    }

    public Optional<Double> getOutcome() {
        return this.gameState.getPlayerOutcome(this.name);
    }

    @Override
    public DemoPlayer deepCopy(DemoState newGameState) {
        return new DemoPlayerImpl(newGameState, this.name, this.possibleOutcomes);
    }
}

