/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.dilemmaCustomized.impl;

import de.fhdw.gaming.core.domain.GameBuilder;
import de.fhdw.gaming.core.domain.GameBuilderFactory;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.Strategy;
import de.fhdw.gaming.core.ui.InputProvider;
import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.validator.MaxValueValidator;
import de.fhdw.gaming.core.ui.type.validator.MinValueValidator;
import de.fhdw.gaming.core.ui.type.validator.Validator;
import de.fhdw.gaming.ipspiel21.customCore.core.domain.CustomGameBuilderFactory;
import de.fhdw.gaming.ipspiel21.customGui.gui.CustomInputProvider;
import de.fhdw.gaming.ipspiel21.dilemmaBasic.DilemmaBasicGameBuilderFactoryImpl;
import de.fhdw.gaming.ipspiel21.dilemmaCustomized.impl.DilemmaCustomizedGameBuilderWrapper;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaGameBuilder;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaStrategy;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.impl.DilemmaGameBuilderFactoryImpl;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.DilemmaMove;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.impl.DilemmaDefaultMoveFactory;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.strategy.DilemmaCustomStrategy;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class DilemmaCustomizedGameBuilderFactoryImpl
implements GameBuilderFactory,
CustomGameBuilderFactory {
    private final Set<DilemmaMove> moves;
    private final DilemmaGameBuilderFactoryImpl originalGameBuilder;

    public DilemmaCustomizedGameBuilderFactoryImpl() {
        DilemmaDefaultMoveFactory moveFactory = new DilemmaDefaultMoveFactory();
        this.moves = new LinkedHashSet<DilemmaMove>();
        this.moves.add(moveFactory.createNoMove());
        this.moves.add(moveFactory.createYesMove());
        this.originalGameBuilder = new DilemmaBasicGameBuilderFactoryImpl();
    }

    public List<? extends Move<?, ?>> getMoves() {
        return new ArrayList<DilemmaMove>(this.moves);
    }

    public String getName() {
        return this.originalGameBuilder.getName() + "Customized";
    }

    public int getMinimumNumberOfPlayers() {
        return this.originalGameBuilder.getMinimumNumberOfPlayers();
    }

    public int getMaximumNumberOfPlayers() {
        return this.originalGameBuilder.getMaximumNumberOfPlayers();
    }

    public List<? extends Strategy<?, ?, ?>> getStrategies() {
        return this.originalGameBuilder.getStrategies();
    }

    public GameBuilder createGameBuilder(InputProvider inputProvider) throws GameException {
        try {
            DilemmaStrategy secondPlayerStrategy;
            DilemmaGameBuilder gameBuilder = this.originalGameBuilder.createGameBuilder(inputProvider);
            DilemmaStrategy firstPlayerStrategy = this.originalGameBuilder.getActualStrategyPlayer1();
            if (firstPlayerStrategy instanceof DilemmaCustomStrategy) {
                Map<String, Object> strategyProperties = this.requestPlayerStrategyProperties(inputProvider, "Strategy-Properties");
                ((DilemmaCustomStrategy)firstPlayerStrategy).setAmountOfGames((Integer)strategyProperties.get("amountGames"));
                ((DilemmaCustomStrategy)firstPlayerStrategy).setInitialMove((DilemmaMove)strategyProperties.get("playerMove"));
                InputProvider numberBasedInputProvider = inputProvider.getNext(strategyProperties);
                Map<String, Object> configuredStrategyDataNumberBased = this.requestPlayerStrategyNumberBased(numberBasedInputProvider, "Number based set up - Strategy-Properties");
                ((DilemmaCustomStrategy)firstPlayerStrategy).setProvidedMoveData(configuredStrategyDataNumberBased);
                this.originalGameBuilder.setActualStrategyPlayer1(firstPlayerStrategy);
            }
            if ((secondPlayerStrategy = this.originalGameBuilder.getActualStrategyPlayer2()) instanceof DilemmaCustomStrategy) {
                Map<String, Object> strategyProperties = this.requestPlayerStrategyProperties(inputProvider, "Strategy-Properties");
                ((DilemmaCustomStrategy)secondPlayerStrategy).setAmountOfGames((Integer)strategyProperties.get("amountGames"));
                ((DilemmaCustomStrategy)secondPlayerStrategy).setInitialMove((DilemmaMove)strategyProperties.get("playerMove"));
                InputProvider numberBasedInputProvider = inputProvider.getNext(strategyProperties);
                Map<String, Object> configuredStrategyDataNumberBased = this.requestPlayerStrategyNumberBased(numberBasedInputProvider, "Number based set up - Strategy-Properties");
                ((DilemmaCustomStrategy)secondPlayerStrategy).setProvidedMoveData(configuredStrategyDataNumberBased);
                this.originalGameBuilder.setActualStrategyPlayer2(secondPlayerStrategy);
            }
            return new DilemmaCustomizedGameBuilderWrapper(gameBuilder);
        }
        catch (InputProviderException e) {
            throw new GameException(String.format("Creating dilemma game was aborted: %s", e.getMessage()), (Throwable)e);
        }
    }

    private Map<String, Object> requestPlayerStrategyProperties(InputProvider inputProvider, String title) throws GameException, InputProviderException {
        inputProvider.needInteger("amountGames", "Amount of considered last games", Optional.empty(), new Validator[]{new MinValueValidator((Comparable)Integer.valueOf(2)), new MaxValueValidator((Comparable)Integer.valueOf(10))}).needObject("playerMove", "Initial move", Optional.empty(), this.moves);
        return inputProvider.requestData(title);
    }

    private Map<String, Object> requestPlayerStrategyNumberBased(InputProvider inputProvider, String title) throws InputProviderException {
        for (DilemmaMove dilemmaMove : this.moves) {
            inputProvider.needObject(dilemmaMove.toString() + " Numberbased100", "100% " + dilemmaMove.toString() + " and my choice is: ", Optional.empty(), this.moves).needObject(dilemmaMove.toString() + " Numberbased50", ">50% " + dilemmaMove.toString() + " and my choice is: ", Optional.empty(), this.moves);
        }
        return inputProvider.requestData(title);
    }

    public InputProvider extendInputProvider(InputProvider inputProvider) throws InputProviderException {
        return new CustomInputProvider(inputProvider);
    }
}

