/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Strategy;
import de.fhdw.gaming.core.ui.InputProvider;
import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.validator.MaxValueValidator;
import de.fhdw.gaming.core.ui.type.validator.MinValueValidator;
import de.fhdw.gaming.core.ui.type.validator.PatternValidator;
import de.fhdw.gaming.core.ui.type.validator.Validator;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaGameBuilder;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaGameBuilderFactory;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaPlayerBuilder;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaStrategy;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.factory.DilemmaDefaultStrategyFactoryProvider;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.factory.DilemmaStrategyFactory;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.factory.DilemmaStrategyFactoryProvider;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.impl.DilemmaGameBuilderImpl;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.impl.AbstractDilemmaMove;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.impl.DilemmaBeSilentMove;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.impl.DilemmaConfessMove;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.impl.DilemmaDefaultMoveFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class DilemmaGameBuilderFactoryImpl
implements DilemmaGameBuilderFactory {
    private static final int NUMBER_OF_PLAYERS = 2;
    private static final int MIN_MAX_COMPUTATION_TIME_PER_MOVE = 1;
    private static final int MAX_MAX_COMPUTATION_TIME_PER_MOVE = 3600;
    private final Set<DilemmaStrategy> strategies;
    private DilemmaStrategy actualStrategyPlayer1;
    private DilemmaStrategy actualStrategyPlayer2;

    public DilemmaGameBuilderFactoryImpl() {
        this(new DilemmaDefaultStrategyFactoryProvider());
    }

    DilemmaGameBuilderFactoryImpl(DilemmaStrategyFactoryProvider strategyFactoryProvider) {
        DilemmaDefaultMoveFactory moveFactory = new DilemmaDefaultMoveFactory();
        List<DilemmaStrategyFactory> factories = strategyFactoryProvider.getStrategyFactories();
        this.strategies = new LinkedHashSet<DilemmaStrategy>();
        for (DilemmaStrategyFactory factory : factories) {
            this.strategies.add(factory.create(moveFactory));
        }
    }

    public String getName() {
        return "Dilemma";
    }

    public int getMinimumNumberOfPlayers() {
        return 2;
    }

    public int getMaximumNumberOfPlayers() {
        return 2;
    }

    public List<? extends Strategy<?, ?, ?>> getStrategies() {
        return new ArrayList<DilemmaStrategy>(this.strategies);
    }

    @Override
    public DilemmaGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException {
        try {
            DilemmaStrategy secondPlayerStrategy;
            DilemmaStrategy firstPlayerStrategy;
            DilemmaGameBuilderImpl gameBuilder = new DilemmaGameBuilderImpl();
            Map gameData = inputProvider.needInteger("maxComputationTimePerMove", "Maximum computation time per move in seconds", Optional.of(5), new Validator[]{new MinValueValidator((Comparable)Integer.valueOf(1)), new MaxValueValidator((Comparable)Integer.valueOf(3600))}).requestData("Game properties");
            gameBuilder.changeMaximumComputationTimePerMove((Integer)gameData.get("maxComputationTimePerMove"));
            InputProvider firstPlayerInputProvider = inputProvider.getNext(gameData);
            Map<String, Object> firstPlayerData = this.requestPlayerData(firstPlayerInputProvider, "Player 1");
            DilemmaPlayerBuilder firstPlayerBuilder = this.initPlayerBuilder(gameBuilder.createPlayerBuilder(), firstPlayerData);
            this.actualStrategyPlayer1 = firstPlayerStrategy = this.getStrategy(firstPlayerData);
            gameBuilder.addPlayerBuilder(firstPlayerBuilder, this.actualStrategyPlayer1);
            InputProvider secondPlayerInputProvider = firstPlayerInputProvider.getNext(firstPlayerData);
            Map<String, Object> secondPlayerData = this.requestPlayerData(secondPlayerInputProvider, "Player 2");
            DilemmaPlayerBuilder secondPlayerBuilder = this.initPlayerBuilder(gameBuilder.createPlayerBuilder(), secondPlayerData);
            this.actualStrategyPlayer2 = secondPlayerStrategy = this.getStrategy(secondPlayerData);
            gameBuilder.addPlayerBuilder(secondPlayerBuilder, this.actualStrategyPlayer2);
            return gameBuilder;
        }
        catch (InputProviderException e) {
            throw new GameException(String.format("Creating dilemma game was aborted: %s", e.getMessage()), (Throwable)e);
        }
    }

    public DilemmaStrategy getActualStrategyPlayer1() {
        return this.actualStrategyPlayer1;
    }

    public DilemmaStrategy getActualStrategyPlayer2() {
        return this.actualStrategyPlayer2;
    }

    public void setActualStrategyPlayer1(DilemmaStrategy actualStrategyPlayer1) {
        this.actualStrategyPlayer1 = actualStrategyPlayer1;
    }

    public void setActualStrategyPlayer2(DilemmaStrategy actualStrategyPlayer2) {
        this.actualStrategyPlayer2 = actualStrategyPlayer2;
    }

    private Map<String, Object> requestPlayerData(InputProvider inputProvider, String title) throws GameException, InputProviderException {
        inputProvider.needString("playerName", "Name", Optional.empty(), new Validator[]{new PatternValidator(Pattern.compile("\\S+(\\s+\\S+)*"))}).needInteger("playerOutcomeBothSilent", "Player's outcome on Both Silent", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeSecondConfess", "Player's outcome on SecondConfess", Optional.of(0), new Validator[0]).needInteger("playerOutcomeFirstConfess", "Player's outcome on FirstConfess", Optional.of(-10), new Validator[0]).needInteger("playerOutcomeBothConfess", "Player's outcome on BothConfess", Optional.of(-8), new Validator[0]).needObject("playerStrategy", "Strategy", Optional.empty(), this.strategies);
        return inputProvider.requestData(title);
    }

    private DilemmaPlayerBuilder initPlayerBuilder(DilemmaPlayerBuilder playerBuilder, Map<String, Object> playerData) throws GameException, InputProviderException {
        LinkedHashMap<AbstractDilemmaMove, Map<AbstractDilemmaMove, Double>> possibleOutcomes = new LinkedHashMap<AbstractDilemmaMove, Map<AbstractDilemmaMove, Double>>();
        LinkedHashMap<AbstractDilemmaMove, Double> possibleOutcomesNo = new LinkedHashMap<AbstractDilemmaMove, Double>();
        possibleOutcomesNo.put(new DilemmaConfessMove(), Double.valueOf(((Integer)playerData.get("playerOutcomeBothSilent")).intValue()));
        possibleOutcomesNo.put(new DilemmaBeSilentMove(), Double.valueOf(((Integer)playerData.get("playerOutcomeSecondConfess")).intValue()));
        possibleOutcomes.put(new DilemmaConfessMove(), possibleOutcomesNo);
        LinkedHashMap<AbstractDilemmaMove, Double> possibleOutcomesYes = new LinkedHashMap<AbstractDilemmaMove, Double>();
        possibleOutcomesYes.put(new DilemmaConfessMove(), Double.valueOf(((Integer)playerData.get("playerOutcomeFirstConfess")).intValue()));
        possibleOutcomesYes.put(new DilemmaBeSilentMove(), Double.valueOf(((Integer)playerData.get("playerOutcomeBothConfess")).intValue()));
        possibleOutcomes.put(new DilemmaBeSilentMove(), possibleOutcomesYes);
        return playerBuilder.changeName((String)playerData.get("playerName")).changePossibleOutcomes(possibleOutcomes);
    }

    private DilemmaStrategy getStrategy(Map<String, Object> playerData) {
        return (DilemmaStrategy)playerData.get("playerStrategy");
    }

    public abstract InputProvider extendInputProvider(InputProvider var1) throws InputProviderException;
}

