/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.freizeit.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Strategy;
import de.fhdw.gaming.core.ui.InputProvider;
import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.validator.MaxValueValidator;
import de.fhdw.gaming.core.ui.type.validator.MinValueValidator;
import de.fhdw.gaming.core.ui.type.validator.PatternValidator;
import de.fhdw.gaming.core.ui.type.validator.Validator;
import de.fhdw.gaming.ipspiel21.freizeit.domain.FreizeitGameBuilder;
import de.fhdw.gaming.ipspiel21.freizeit.domain.FreizeitGameBuilderFactory;
import de.fhdw.gaming.ipspiel21.freizeit.domain.FreizeitPlayerBuilder;
import de.fhdw.gaming.ipspiel21.freizeit.domain.FreizeitStrategy;
import de.fhdw.gaming.ipspiel21.freizeit.domain.factory.FreizeitDefaultStrategyFactoryProvider;
import de.fhdw.gaming.ipspiel21.freizeit.domain.factory.FreizeitStrategyFactory;
import de.fhdw.gaming.ipspiel21.freizeit.domain.factory.FreizeitStrategyFactoryProvider;
import de.fhdw.gaming.ipspiel21.freizeit.domain.impl.FreizeitGameBuilderImpl;
import de.fhdw.gaming.ipspiel21.freizeit.moves.impl.AbstractFreizeitMove;
import de.fhdw.gaming.ipspiel21.freizeit.moves.impl.FreizeitCinemaMove;
import de.fhdw.gaming.ipspiel21.freizeit.moves.impl.FreizeitDefaultMoveFactory;
import de.fhdw.gaming.ipspiel21.freizeit.moves.impl.FreizeitSoccerMove;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public final class FreizeitGameBuilderFactoryImpl
implements FreizeitGameBuilderFactory {
    private static final int NUMBER_OF_PLAYERS = 2;
    private static final int MIN_MAX_COMPUTATION_TIME_PER_MOVE = 1;
    private static final int MAX_MAX_COMPUTATION_TIME_PER_MOVE = 3600;
    private final Set<FreizeitStrategy> strategies;

    public FreizeitGameBuilderFactoryImpl() {
        this(new FreizeitDefaultStrategyFactoryProvider());
    }

    FreizeitGameBuilderFactoryImpl(FreizeitStrategyFactoryProvider strategyFactoryProvider) {
        FreizeitDefaultMoveFactory moveFactory = new FreizeitDefaultMoveFactory();
        List<FreizeitStrategyFactory> factories = strategyFactoryProvider.getStrategyFactories();
        this.strategies = new LinkedHashSet<FreizeitStrategy>();
        for (FreizeitStrategyFactory factory : factories) {
            this.strategies.add(factory.create(moveFactory));
        }
    }

    public String getName() {
        return "Freizeit";
    }

    public int getMinimumNumberOfPlayers() {
        return 2;
    }

    public int getMaximumNumberOfPlayers() {
        return 2;
    }

    public List<? extends Strategy<?, ?, ?>> getStrategies() {
        return new ArrayList<FreizeitStrategy>(this.strategies);
    }

    @Override
    public FreizeitGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException {
        try {
            FreizeitGameBuilderImpl gameBuilder = new FreizeitGameBuilderImpl();
            Map gameData = inputProvider.needInteger("maxComputationTimePerMove", "Maximum computation time per move in seconds", Optional.of(5), new Validator[]{new MinValueValidator((Comparable)Integer.valueOf(1)), new MaxValueValidator((Comparable)Integer.valueOf(3600))}).requestData("Game properties");
            gameBuilder.changeMaximumComputationTimePerMove((Integer)gameData.get("maxComputationTimePerMove"));
            InputProvider firstPlayerInputProvider = inputProvider.getNext(gameData);
            Map<String, Object> firstPlayerData = this.requestPlayer1Data(firstPlayerInputProvider, "Player 1");
            FreizeitPlayerBuilder firstPlayerBuilder = this.initPlayerBuilder(gameBuilder.createPlayerBuilder(), firstPlayerData);
            FreizeitStrategy firstPlayerStrategy = this.getStrategy(firstPlayerData);
            gameBuilder.addPlayerBuilder(firstPlayerBuilder, firstPlayerStrategy);
            InputProvider secondPlayerInputProvider = firstPlayerInputProvider.getNext(firstPlayerData);
            Map<String, Object> secondPlayerData = this.requestPlayer2Data(secondPlayerInputProvider, "Player 2");
            FreizeitPlayerBuilder secondPlayerBuilder = this.initPlayerBuilder(gameBuilder.createPlayerBuilder(), secondPlayerData);
            FreizeitStrategy secondPlayerStrategy = this.getStrategy(secondPlayerData);
            gameBuilder.addPlayerBuilder(secondPlayerBuilder, secondPlayerStrategy);
            return gameBuilder;
        }
        catch (InputProviderException e) {
            throw new GameException(String.format("Creating Freizeit game was aborted: %s", e.getMessage()), (Throwable)e);
        }
    }

    private Map<String, Object> requestPlayer1Data(InputProvider inputProvider, String title) throws GameException, InputProviderException {
        inputProvider.needString("playerName", "Name", Optional.empty(), new Validator[]{new PatternValidator(Pattern.compile("\\S+(\\s+\\S+)*"))}).needInteger("playerOutcomeOnCinemaCinema", "Player's outcome on Cinema/Cinema", Optional.of(2), new Validator[0]).needInteger("playerOutcomeOnCinemaSoccer", "Player's outcome on Cinema/Soccer", Optional.of(0), new Validator[0]).needInteger("playerOutcomeOnSoccerCinema", "Player's outcome on Soccer/Cinema", Optional.of(0), new Validator[0]).needInteger("playerOutcomeOnSoccerSoccer", "Player's outcome on Soccer/Soccer", Optional.of(1), new Validator[0]).needObject("playerStrategy", "Strategy", Optional.empty(), this.strategies);
        return inputProvider.requestData(title);
    }

    private Map<String, Object> requestPlayer2Data(InputProvider inputProvider, String title) throws GameException, InputProviderException {
        inputProvider.needString("playerName", "Name", Optional.empty(), new Validator[]{new PatternValidator(Pattern.compile("\\S+(\\s+\\S+)*"))}).needInteger("playerOutcomeOnCinemaCinema", "Player's outcome on Cinema/Cinema", Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnCinemaSoccer", "Player's outcome on Cinema/Soccer", Optional.of(0), new Validator[0]).needInteger("playerOutcomeOnSoccerCinema", "Player's outcome on Soccer/Cinema", Optional.of(0), new Validator[0]).needInteger("playerOutcomeOnSoccerSoccer", "Player's outcome on Soccer/Soccer", Optional.of(2), new Validator[0]).needObject("playerStrategy", "Strategy", Optional.empty(), this.strategies);
        return inputProvider.requestData(title);
    }

    private FreizeitPlayerBuilder initPlayerBuilder(FreizeitPlayerBuilder playerBuilder, Map<String, Object> playerData) throws GameException, InputProviderException {
        LinkedHashMap<AbstractFreizeitMove, Map<AbstractFreizeitMove, Double>> possibleOutcomes = new LinkedHashMap<AbstractFreizeitMove, Map<AbstractFreizeitMove, Double>>();
        LinkedHashMap<AbstractFreizeitMove, Double> possibleOutcomesCinema = new LinkedHashMap<AbstractFreizeitMove, Double>();
        possibleOutcomesCinema.put(new FreizeitCinemaMove(), Double.valueOf(((Integer)playerData.get("playerOutcomeOnCinemaCinema")).intValue()));
        possibleOutcomesCinema.put(new FreizeitSoccerMove(), Double.valueOf(((Integer)playerData.get("playerOutcomeOnCinemaSoccer")).intValue()));
        possibleOutcomes.put(new FreizeitCinemaMove(), possibleOutcomesCinema);
        LinkedHashMap<AbstractFreizeitMove, Double> possibleOutcomesSoccer = new LinkedHashMap<AbstractFreizeitMove, Double>();
        possibleOutcomesSoccer.put(new FreizeitCinemaMove(), Double.valueOf(((Integer)playerData.get("playerOutcomeOnSoccerCinema")).intValue()));
        possibleOutcomesSoccer.put(new FreizeitSoccerMove(), Double.valueOf(((Integer)playerData.get("playerOutcomeOnSoccerSoccer")).intValue()));
        possibleOutcomes.put(new FreizeitSoccerMove(), possibleOutcomesSoccer);
        return playerBuilder.changeName((String)playerData.get("playerName")).changePossibleOutcomes(possibleOutcomes);
    }

    private FreizeitStrategy getStrategy(Map<String, Object> playerData) {
        return (FreizeitStrategy)playerData.get("playerStrategy");
    }
}

