/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.freizeit.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel21.freizeit.domain.FreizeitPlayer;
import de.fhdw.gaming.ipspiel21.freizeit.domain.FreizeitPlayerBuilder;
import de.fhdw.gaming.ipspiel21.freizeit.domain.FreizeitState;
import de.fhdw.gaming.ipspiel21.freizeit.domain.impl.FreizeitPlayerImpl;
import de.fhdw.gaming.ipspiel21.freizeit.moves.impl.AbstractFreizeitMove;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

final class FreizeitPlayerBuilderImpl
implements FreizeitPlayerBuilder {
    private Optional<String> name = Optional.empty();
    private Optional<Map<AbstractFreizeitMove, Map<AbstractFreizeitMove, Double>>> possibleOutcomes = Optional.empty();

    FreizeitPlayerBuilderImpl() {
    }

    @Override
    public FreizeitPlayerBuilderImpl changeName(String newName) {
        this.name = Optional.of(newName);
        return this;
    }

    @Override
    public FreizeitPlayerBuilder changePossibleOutcomes(Map<AbstractFreizeitMove, Map<AbstractFreizeitMove, Double>> newPossibleOutcomes) {
        this.possibleOutcomes = Optional.of(newPossibleOutcomes);
        return this;
    }

    @Override
    public FreizeitPlayer build(FreizeitState state) throws GameException {
        return new FreizeitPlayerImpl(state, this.name.orElseThrow(), this.checkPossibleOutcomes(this.possibleOutcomes.orElseThrow()));
    }

    private Map<AbstractFreizeitMove, Map<AbstractFreizeitMove, Double>> checkPossibleOutcomes(Map<AbstractFreizeitMove, Map<AbstractFreizeitMove, Double>> outcomes) {
        if (!FreizeitPlayerBuilderImpl.isNullOrEmptyOuterMap(outcomes) && !FreizeitPlayerBuilderImpl.isNullOrEmptyInnerMap(outcomes.values())) {
            return outcomes;
        }
        throw new IllegalArgumentException();
    }

    private static boolean isNullOrEmptyOuterMap(Map<AbstractFreizeitMove, Map<AbstractFreizeitMove, Double>> outcomes) {
        if (outcomes.isEmpty()) {
            throw new IllegalArgumentException("The outcomes are not defined");
        }
        Iterator<Map<AbstractFreizeitMove, Double>> it = outcomes.values().iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            throw new IllegalArgumentException("The value is not defined: " + it.next());
        }
        return false;
    }

    private static boolean isNullOrEmptyInnerMap(Collection<Map<AbstractFreizeitMove, Double>> outcomes) {
        if (outcomes.isEmpty()) {
            throw new IllegalArgumentException("The outcomes are not defined");
        }
        Iterator<Map<AbstractFreizeitMove, Double>> it = outcomes.iterator();
        while (it.hasNext()) {
            if (it.next().values() != null) continue;
            throw new IllegalArgumentException("The value is not defined: " + it.next());
        }
        return false;
    }
}

