/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.kopfzahl.domain.impl;

import de.fhdw.gaming.core.domain.DefaultObserverFactoryProvider;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.KopfzahlGame;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.KopfzahlGameBuilder;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.KopfzahlPlayerBuilder;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.KopfzahlStrategy;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.impl.KopfzahlGameImpl;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.impl.KopfzahlPlayerBuilderImpl;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.impl.KopfzahlStateImpl;
import de.fhdw.gaming.ipspiel21.kopfzahl.moves.impl.AbstractKopfzahlMove;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;

final class KopfzahlGameBuilderImpl
implements KopfzahlGameBuilder {
    private ObserverFactoryProvider observerFactoryProvider = new DefaultObserverFactoryProvider();
    private Optional<KopfzahlPlayerBuilder> firstPlayer = Optional.empty();
    private Optional<KopfzahlStrategy> firstPlayerStrategy = Optional.empty();
    private Optional<KopfzahlPlayerBuilder> secondPlayer = Optional.empty();
    private Optional<KopfzahlStrategy> secondPlayerStrategy = Optional.empty();
    private int maxComputationTimePerMove = 5;

    KopfzahlGameBuilderImpl() {
    }

    @Override
    public KopfzahlPlayerBuilder createPlayerBuilder() {
        return new KopfzahlPlayerBuilderImpl();
    }

    @Override
    public KopfzahlGameBuilder addPlayerBuilder(KopfzahlPlayerBuilder playerBuilder, KopfzahlStrategy strategy) throws GameException {
        Objects.requireNonNull(playerBuilder);
        if (this.firstPlayer.isEmpty()) {
            this.firstPlayer = Optional.of(playerBuilder);
            this.firstPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "firstPlayerStrategy"));
        } else if (this.secondPlayer.isEmpty()) {
            this.secondPlayer = Optional.of(playerBuilder);
            this.secondPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "secondPlayerStrategy"));
        } else {
            throw new GameException(String.format("More than two players are now allowed.", new Object[0]));
        }
        return this;
    }

    public KopfzahlGameBuilder changeMaximumComputationTimePerMove(int newMaxComputationTimePerMove) {
        this.maxComputationTimePerMove = newMaxComputationTimePerMove;
        return this;
    }

    @Override
    public KopfzahlGameBuilder changeObserverFactoryProvider(ObserverFactoryProvider newObserverFactoryProvider) {
        this.observerFactoryProvider = newObserverFactoryProvider;
        return this;
    }

    @Override
    public KopfzahlGame build(int id) throws GameException, InterruptedException {
        if (!this.firstPlayer.isPresent() || !this.secondPlayer.isPresent()) {
            throw new GameException("A Kopfzahl game needs two players.");
        }
        KopfzahlStateImpl initialState = new KopfzahlStateImpl(this.firstPlayer.get(), this.secondPlayer.get());
        LinkedHashMap<String, KopfzahlStrategy> strategies = new LinkedHashMap<String, KopfzahlStrategy>();
        strategies.put(initialState.getFirstPlayer().getName(), this.firstPlayerStrategy.orElseThrow());
        strategies.put(initialState.getSecondPlayer().getName(), this.secondPlayerStrategy.orElseThrow());
        return new KopfzahlGameImpl(id, initialState, strategies, this.maxComputationTimePerMove, AbstractKopfzahlMove.class::isInstance, this.observerFactoryProvider);
    }
}

